/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.directoryparams;

import de.skuzzle.test.snapshots.directoryparams.FileExtension;
import de.skuzzle.test.snapshots.directoryparams.TestDirectory;
import de.skuzzle.test.snapshots.validation.Arguments;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL)
public final class TestFile {
    private final Path file;
    private static final Pattern REPLACIBLE_VAR = Pattern.compile("\\$\\{(.*)\\}");

    TestFile(Path file) {
        Arguments.requireNonNull((Object)file, (String)"file must not be null");
        Arguments.check((boolean)Files.exists(file, new LinkOption[0]), (String)"file doesn't exist: %s", (Object[])new Object[]{file});
        Arguments.check((boolean)Files.isRegularFile(file, new LinkOption[0]), (String)"file is not a regular file: %s", (Object[])new Object[]{file});
        this.file = file;
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.2.0")
    public TestFile sibling(String fileName) {
        Arguments.requireNonNull((Object)fileName, (String)"sibling fileName must not be null");
        return new TestFile(this.directory().resolve(fileName));
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.2.0")
    public TestFile siblingWithExtension(String extension) {
        Arguments.requireNonNull((Object)extension, (String)"sibling extension must not be null");
        return this.testDirectory().resolve(this.name() + "." + extension);
    }

    public Path file() {
        return this.file;
    }

    @Deprecated(forRemoval=true, since="1.2.0")
    @API(status=API.Status.DEPRECATED, since="1.2.0")
    public Path directory() {
        return this.file.getParent();
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.2.0")
    public TestDirectory testDirectory() {
        return new TestDirectory(this.file.getParent());
    }

    public String name() {
        String fileName = this.file.getFileName().toString();
        int dot = fileName.lastIndexOf(46);
        return dot < 0 ? fileName : fileName.substring(0, dot);
    }

    public String nameWithExtension() {
        return this.file.getFileName().toString();
    }

    public String extension() {
        return FileExtension.withoutLeadingDot(this.file);
    }

    public InputStream openStream() throws IOException {
        return Files.newInputStream(this.file, new OpenOption[0]);
    }

    public byte[] asBinary() throws IOException {
        try (InputStream inputStream = this.openStream();){
            byte[] byArray = inputStream.readAllBytes();
            return byArray;
        }
    }

    public String asText(Charset charset) throws IOException {
        return new String(this.asBinary(), (Charset)Arguments.requireNonNull((Object)charset, (String)"charset must not be null"));
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.3.0")
    public String asText() throws IOException {
        return this.asText(StandardCharsets.UTF_8);
    }

    String asText(Charset charset, Map<String, ? extends Object> context) throws IOException {
        String raw = new String(this.asBinary(), charset);
        HashSet<String> replacedVariables = new HashSet<String>(context.size());
        Matcher matcher = REPLACIBLE_VAR.matcher(raw);
        StringBuilder b = new StringBuilder(raw.length());
        while (matcher.find()) {
            String varName = matcher.group(1);
            Object replacement = context.get(varName);
            if (replacement == null) {
                throw new IllegalArgumentException(String.format("Could not resolve variable '%s' in TestFile '%s'. Given context object contains no replacement: %s", varName, this.nameWithExtension(), context));
            }
            replacedVariables.add(varName);
            matcher.appendReplacement(b, replacement.toString());
        }
        matcher.appendTail(b);
        return b.toString();
    }

    public String toString() {
        try {
            return this.file.toAbsolutePath().toRealPath(new LinkOption[0]).toString();
        }
        catch (IOException e) {
            return this.file.toAbsolutePath().toString();
        }
    }
}

