/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.directoryparams;

import de.skuzzle.test.snapshots.directoryparams.TestFile;
import de.skuzzle.test.snapshots.io.UncheckedIO;
import de.skuzzle.test.snapshots.validation.Arguments;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL, since="1.2.0")
public final class TestDirectory {
    private final Path directory;

    TestDirectory(Path directory) {
        Arguments.requireNonNull((Object)directory, (String)"directory must not be null");
        Arguments.check((boolean)Files.exists(directory, new LinkOption[0]), (String)"directory doesn't exist: %s", (Object[])new Object[]{directory});
        Arguments.check((boolean)Files.isDirectory(directory, new LinkOption[0]), (String)"directory is not a regular directory: %s", (Object[])new Object[]{directory});
        this.directory = directory;
    }

    public Path path() {
        return this.directory;
    }

    public String name() {
        return this.directory.getFileName().toString();
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.9.0")
    public boolean hasSubDirectories() {
        return UncheckedIO.list((Path)this.directory).anyMatch(x$0 -> Files.isDirectory(x$0, new LinkOption[0]));
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.9.0")
    public boolean containsFile(String fileName) {
        Arguments.requireNonNull((Object)fileName, (String)"fileName must not be null");
        return Files.exists(this.directory.resolve(fileName), new LinkOption[0]);
    }

    public TestFile resolve(String fileName) {
        Arguments.requireNonNull((Object)fileName, (String)"fileName must not be null");
        return new TestFile(this.directory.resolve(fileName));
    }

    public Stream<TestFile> files() {
        return UncheckedIO.list((Path)this.directory).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(TestFile::new);
    }

    public String toString() {
        try {
            return this.directory.toAbsolutePath().toRealPath(new LinkOption[0]).toString();
        }
        catch (IOException e) {
            return this.directory.toAbsolutePath().toString();
        }
    }
}

