/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.directoryparams;

import de.skuzzle.test.snapshots.directoryparams.TestFile;
import de.skuzzle.test.snapshots.directoryparams.TestFileFilter;
import de.skuzzle.test.snapshots.validation.Arguments;
import java.io.IOException;
import java.util.Arrays;

final class PathFilterExtensions
implements TestFileFilter {
    private final String[] extensions;

    static TestFileFilter extensions(String[] extensionsArrays) {
        return new PathFilterExtensions(extensionsArrays);
    }

    private PathFilterExtensions(String[] extensions) {
        this.extensions = (String[])Arguments.requireNonNull((Object)extensions, (String)"extensions array must not be null");
    }

    @Override
    public boolean include(TestFile testFile, boolean recursive) throws IOException {
        return this.extensions.length == 0 || Arrays.stream(this.extensions).anyMatch(configuredExtension -> this.matchesExtension((String)configuredExtension, testFile));
    }

    private boolean matchesExtension(String configuredExtension, TestFile testFile) {
        String normalizedExtensionWithoutDot = configuredExtension.startsWith(".") ? configuredExtension.substring(1) : configuredExtension;
        String filesExtensionWithoutDot = testFile.extension();
        return filesExtensionWithoutDot.equalsIgnoreCase(normalizedExtensionWithoutDot);
    }
}

