/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.directoryparams;

import de.skuzzle.test.snapshots.directoryparams.TestDirectory;
import de.skuzzle.test.snapshots.directoryparams.TestDirectoryFilter;
import de.skuzzle.test.snapshots.directoryparams.TestFile;
import de.skuzzle.test.snapshots.directoryparams.TestFileFilter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Predicate;

final class Filters {
    private Filters() {
    }

    static TestFileFilter and(TestFileFilter filter1, TestFileFilter filter2) {
        return (testFile, recursive) -> filter1.include(testFile, recursive) && filter2.include(testFile, recursive);
    }

    static Predicate<TestFile> toPredicate(TestFileFilter filter, boolean recursive) {
        return testFile -> {
            try {
                return filter.include((TestFile)testFile, recursive);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    static Predicate<TestDirectory> toPredicate(TestDirectoryFilter filter, boolean recursive) {
        return testDirectory -> {
            try {
                return filter.include((TestDirectory)testDirectory, recursive);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    static final class TestDirectoryFilterAll
    implements TestDirectoryFilter {
        TestDirectoryFilterAll() {
        }

        @Override
        public boolean include(TestDirectory testDirectory, boolean recursive) throws IOException {
            return recursive ? !testDirectory.hasSubDirectories() : true;
        }
    }

    static final class TestFileFilterAll
    implements TestFileFilter {
        TestFileFilterAll() {
        }

        @Override
        public boolean include(TestFile testFile, boolean recursive) throws IOException {
            return true;
        }
    }
}

