/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.directoryparams;

import de.skuzzle.test.snapshots.directoryparams.AnnotationDirectoryResolver;
import de.skuzzle.test.snapshots.directoryparams.FilesFrom;
import de.skuzzle.test.snapshots.directoryparams.Filters;
import de.skuzzle.test.snapshots.directoryparams.PathFilterExtensions;
import de.skuzzle.test.snapshots.directoryparams.TestFile;
import de.skuzzle.test.snapshots.directoryparams.TestFileFilter;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.support.AnnotationConsumer;
import org.junit.platform.commons.support.ReflectionSupport;

class FilesFromArgumentsProvider
implements ArgumentsProvider,
AnnotationConsumer<FilesFrom> {
    private FilesFrom filesFrom;

    FilesFromArgumentsProvider() {
    }

    public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
        Path inputFileDirectory = this.determineDirectory().toAbsolutePath().toRealPath(new LinkOption[0]);
        boolean isRecursive = this.filesFrom.recursive();
        TestFileFilter filter = Filters.and(PathFilterExtensions.extensions(this.filesFrom.extensions()), this.testFileFilter());
        Stream<TestFile> files = isRecursive ? this.provideArgumentsRecursive(inputFileDirectory) : this.provideArgumentsFlat(inputFileDirectory);
        return files.filter(Filters.toPredicate(filter, isRecursive)).sorted(Comparator.comparing(TestFile::name)).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    private Stream<TestFile> provideArgumentsFlat(Path inputFileDirectory) throws Exception {
        return Files.list(inputFileDirectory).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(TestFile::new);
    }

    private Stream<TestFile> provideArgumentsRecursive(Path inputFileDirectory) throws Exception {
        return Files.walk(inputFileDirectory, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(TestFile::new);
    }

    private TestFileFilter testFileFilter() {
        return (TestFileFilter)ReflectionSupport.newInstance(this.filesFrom.filter(), (Object[])new Object[0]);
    }

    private Path determineDirectory() throws IOException {
        String legacyDir = this.filesFrom.directory();
        String testResourcesDir = this.filesFrom.testResourcesDirectory();
        String projectDir = this.filesFrom.projectDirectory();
        return AnnotationDirectoryResolver.resolveDirectory(legacyDir, projectDir, testResourcesDir);
    }

    public void accept(FilesFrom t) {
        this.filesFrom = t;
    }
}

