/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.directoryparams;

import de.skuzzle.test.snapshots.directoryparams.AnnotationDirectoryResolver;
import de.skuzzle.test.snapshots.directoryparams.DirectoriesFrom;
import de.skuzzle.test.snapshots.directoryparams.Filters;
import de.skuzzle.test.snapshots.directoryparams.TestDirectory;
import de.skuzzle.test.snapshots.directoryparams.TestDirectoryFilter;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.support.AnnotationConsumer;
import org.junit.platform.commons.support.ReflectionSupport;

class DirectoriesFromArgumentsProvider
implements ArgumentsProvider,
AnnotationConsumer<DirectoriesFrom> {
    private DirectoriesFrom directoryContents;

    DirectoriesFromArgumentsProvider() {
    }

    public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
        Path inputFileDirectory = this.determineDirectory().toAbsolutePath().toRealPath(new LinkOption[0]);
        boolean isRecursive = this.directoryContents.recursive();
        Stream<TestDirectory> directories = isRecursive ? this.provideArgumentsRecursive(inputFileDirectory) : this.provideArgumentsFlat(inputFileDirectory);
        TestDirectoryFilter additionalFilter = this.testDirectoryFilter();
        return directories.filter(Filters.toPredicate(additionalFilter, isRecursive)).sorted(Comparator.comparing(TestDirectory::name)).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    private Stream<TestDirectory> provideArgumentsFlat(Path inputFileDirectory) throws Exception {
        return Files.list(inputFileDirectory).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(TestDirectory::new);
    }

    private Stream<TestDirectory> provideArgumentsRecursive(Path inputFileDirectory) throws Exception {
        return Files.walk(inputFileDirectory, new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(TestDirectory::new);
    }

    private TestDirectoryFilter testDirectoryFilter() {
        return (TestDirectoryFilter)ReflectionSupport.newInstance(this.directoryContents.filter(), (Object[])new Object[0]);
    }

    private Path determineDirectory() throws IOException {
        String legacyDir = this.directoryContents.directory();
        String testResourcesDir = this.directoryContents.testResourcesDirectory();
        String projectDir = this.directoryContents.projectDirectory();
        return AnnotationDirectoryResolver.resolveDirectory(legacyDir, projectDir, testResourcesDir);
    }

    public void accept(DirectoriesFrom t) {
        this.directoryContents = t;
    }
}

