/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.directoryparams;

import de.skuzzle.test.snapshots.directoryparams.FileExtension;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TestFile {
    private final Path file;
    private static final Pattern REPLACIBLE_VAR = Pattern.compile("\\$\\{(.*)\\}");

    TestFile(Path file) {
        this.file = Objects.requireNonNull(file, "file must not be null");
    }

    public Path file() {
        return this.file;
    }

    public Path directory() {
        return this.file.getParent();
    }

    public String name() {
        String fileName = this.file.getFileName().toString();
        int dot = fileName.lastIndexOf(46);
        return dot < 0 ? fileName : fileName.substring(0, dot);
    }

    public String nameWithExtension() {
        return this.file.getFileName().toString();
    }

    public String extension() {
        return FileExtension.withoutLeadingDot(this.file);
    }

    public InputStream openStream() throws IOException {
        return Files.newInputStream(this.file, new OpenOption[0]);
    }

    public byte[] asBinary() throws IOException {
        try (InputStream inputStream = this.openStream();){
            byte[] byArray = inputStream.readAllBytes();
            return byArray;
        }
    }

    public String asText(Charset charset) throws IOException {
        return new String(this.asBinary(), Objects.requireNonNull(charset, "charset must not be null"));
    }

    String asText(Charset charset, Map<String, ? extends Object> context) throws IOException {
        String raw = new String(this.asBinary(), charset);
        HashSet<String> replacedVariables = new HashSet<String>(context.size());
        Matcher matcher = REPLACIBLE_VAR.matcher(raw);
        StringBuilder b = new StringBuilder(raw.length());
        while (matcher.find()) {
            String varName = matcher.group(1);
            Object replacement = context.get(varName);
            if (replacement == null) {
                throw new IllegalArgumentException(String.format("Could not resolve variable '%s' in TestFile '%s'. Given context object contains no replacement: %s", varName, this.nameWithExtension(), context));
            }
            replacedVariables.add(varName);
            matcher.appendReplacement(b, replacement.toString());
        }
        matcher.appendTail(b);
        return b.toString();
    }
}

