/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.directoryparams;

import de.skuzzle.test.snapshots.directoryparams.DirectoryResolver;
import de.skuzzle.test.snapshots.directoryparams.FileExtension;
import de.skuzzle.test.snapshots.directoryparams.FilesFrom;
import de.skuzzle.test.snapshots.directoryparams.TestFile;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.support.AnnotationConsumer;

class DirectoryContentsArgumentsProvider
implements ArgumentsProvider,
AnnotationConsumer<FilesFrom> {
    private FilesFrom directoryContents;

    DirectoryContentsArgumentsProvider() {
    }

    public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
        Path inputFileDirectory = this.determineDirectory().toAbsolutePath();
        return this.streamFiles(inputFileDirectory).filter(this::includeFile).map(TestFile::new).sorted(Comparator.comparing(TestFile::name)).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    private Stream<Path> streamFiles(Path root) throws IOException {
        return this.directoryContents.recursive() ? Files.walk(root, new FileVisitOption[0]) : Files.list(root);
    }

    private boolean includeFile(Path file) {
        return this.directoryContents.extensions().length == 0 || Arrays.stream(this.directoryContents.extensions()).anyMatch(configuredExtension -> this.matchesExtension((String)configuredExtension, file));
    }

    private boolean matchesExtension(String configuredExtension, Path file) {
        Object normalizedExtension = configuredExtension.startsWith(".") ? configuredExtension : "." + configuredExtension;
        String filesExtension = FileExtension.includingLeadingDot(file);
        return filesExtension.equalsIgnoreCase((String)normalizedExtension);
    }

    private Path determineDirectory() throws IOException {
        return DirectoryResolver.resolve(this.directoryContents);
    }

    public void accept(FilesFrom t) {
        this.directoryContents = t;
    }
}

