/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.impl;

import de.skuzzle.test.snapshots.ContextFiles;
import de.skuzzle.test.snapshots.Snapshot;
import de.skuzzle.test.snapshots.SnapshotDsl;
import de.skuzzle.test.snapshots.SnapshotTestResult;
import de.skuzzle.test.snapshots.impl.DefaultSnapshotConfiguration;
import de.skuzzle.test.snapshots.impl.DynamicOrphanedSnapshotsDetector;
import de.skuzzle.test.snapshots.impl.InternalSnapshotNaming;
import de.skuzzle.test.snapshots.impl.OrphanCollectorHolder;
import de.skuzzle.test.snapshots.impl.OrphanDetectionResult;
import de.skuzzle.test.snapshots.impl.OrphanPostProcessor;
import de.skuzzle.test.snapshots.impl.ResultRecorder;
import de.skuzzle.test.snapshots.impl.SnapshotConfiguration;
import de.skuzzle.test.snapshots.impl.SnapshotDslImpl;
import de.skuzzle.test.snapshots.impl.StaticOrphanedSnapshotDetector;
import de.skuzzle.test.snapshots.io.DirectoryResolver;
import de.skuzzle.test.snapshots.validation.Arguments;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL, since="1.1.0")
public final class SnapshotTestContext {
    private final DynamicOrphanedSnapshotsDetector dynamicOrphanedSnapshotsDetector = new DynamicOrphanedSnapshotsDetector();
    private final SnapshotConfiguration snapshotConfiguration;
    private SnapshotDslImpl currentSnapshotTest;

    private SnapshotTestContext(SnapshotConfiguration snapshotConfiguration) {
        this.snapshotConfiguration = (SnapshotConfiguration)Arguments.requireNonNull((Object)snapshotConfiguration, (String)"snapshotConfiguration must not be null");
    }

    @Deprecated(since="1.7.0")
    public static SnapshotTestContext forTestClass(Class<?> testClass) {
        SnapshotConfiguration configuration = DefaultSnapshotConfiguration.forTestClass(testClass);
        return new SnapshotTestContext(configuration);
    }

    public static SnapshotTestContext forConfiguration(SnapshotConfiguration snapshotConfiguration) {
        return new SnapshotTestContext(snapshotConfiguration);
    }

    @API(status=API.Status.INTERNAL, since="1.9.0")
    public SnapshotConfiguration snapshotConfiguration() {
        return this.snapshotConfiguration;
    }

    public boolean isSnapshotParameter(Class<?> type) {
        return SnapshotDsl.Snapshot.class.isAssignableFrom(type);
    }

    public Snapshot createSnapshotTestFor(Method testMethod) {
        if (this.currentSnapshotTest != null) {
            throw new IllegalStateException("There is already a current snapshot test");
        }
        ResultRecorder resultRecorder = ResultRecorder.forFreshTestMethod(this);
        this.currentSnapshotTest = new SnapshotDslImpl(resultRecorder, this.snapshotConfiguration, testMethod);
        return this.currentSnapshotTest;
    }

    public void finalizeSnapshotTest() throws Exception {
        SnapshotDslImpl current = this.currentSnapshotTest;
        this.currentSnapshotTest = null;
        if (current != null) {
            current.executeFinalAssertions();
        }
    }

    public void recordFailedOrSkippedTest(Method testMethod) {
        this.dynamicOrphanedSnapshotsDetector.addFailedOrSkippedTestMethod(testMethod);
    }

    void recordSnapshotTestResult(SnapshotTestResult result) {
        this.dynamicOrphanedSnapshotsDetector.addResult(result);
    }

    public Collection<Path> detectOrCleanupOrphanedSnapshots() {
        boolean deleteOrphaned = this.snapshotConfiguration.isDeleteOrphanedSnapshots();
        Path globalSnapshotDirectory = this.snapshotConfiguration.determineSnapshotDirectory();
        OrphanCollectorHolder.OrphanCollector collector = OrphanCollectorHolder.getCollector();
        Stream<OrphanDetectionResult> dynamicOrphans = this.dynamicOrphanedSnapshotsDetector.detectOrphans(globalSnapshotDirectory).peek(collector::addRawResult);
        Stream<OrphanDetectionResult> staticOrphans = new StaticOrphanedSnapshotDetector().detectOrphans(DirectoryResolver.BASE).peek(collector::addRawResult);
        return new OrphanPostProcessor().orphanedOnly(Stream.concat(dynamicOrphans, staticOrphans).collect(Collectors.toList())).peek(collector::addPostProcessedResult).map(OrphanDetectionResult::snapshotFile).distinct().peek(orphanedSnapshotFile -> {
            Path relativePath = DirectoryResolver.relativize((Path)orphanedSnapshotFile.getParent());
            if (deleteOrphaned) {
                ContextFiles contextFiles = InternalSnapshotNaming.contextFilesForSnapshotFile(orphanedSnapshotFile);
                contextFiles.deleteFiles();
                System.err.printf("Deleted orphaned snapshot file %s in %s%n", orphanedSnapshotFile.getFileName(), relativePath);
            } else {
                System.err.printf("Found orphaned snapshot file. Run with '@DeleteOrphanedSnapshots' annotation to remove: %s in %s%n", orphanedSnapshotFile.getFileName(), relativePath);
            }
        }).collect(Collectors.toList());
    }

    public String toString() {
        return "SnapshotTestContext[" + this.snapshotConfiguration + "]";
    }
}

