/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.impl;

import de.skuzzle.test.snapshots.ContextFiles;
import de.skuzzle.test.snapshots.SnapshotException;
import de.skuzzle.test.snapshots.SnapshotFile;
import de.skuzzle.test.snapshots.SnapshotTestResult;
import de.skuzzle.test.snapshots.StructuralAssertions;
import de.skuzzle.test.snapshots.data.text.TextDiff;
import de.skuzzle.test.snapshots.data.text.TextDiffAssertionError;
import de.skuzzle.test.snapshots.impl.SnapshotAssertionInput;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import org.opentest4j.AssertionFailedError;

final class SnapshotAssertionExecutor {
    SnapshotAssertionExecutor() {
    }

    public SnapshotTestResult execute(StructuralAssertions structuralAssertions, SnapshotAssertionInput assertionInput) throws IOException {
        SnapshotFile actualSnapshotFile = assertionInput.actualSnapshotFile();
        ContextFiles contextFiles = assertionInput.contextFiles();
        String serializedActual = actualSnapshotFile.snapshot();
        SnapshotTestResult.SnapshotStatus status = this.determineStatus(assertionInput);
        if (status == SnapshotTestResult.SnapshotStatus.ASSERTED) {
            SnapshotFile existingSnapshotFile = SnapshotFile.fromSnapshotFile(contextFiles.snapshotFile());
            String serializedExpected = existingSnapshotFile.snapshot();
            return this.compareTestResults(structuralAssertions, serializedExpected, serializedActual, contextFiles.snapshotFile(), assertionInput.lineNumberOffset(), assertionInput.contextLines()).map(assertionError -> SnapshotTestResult.forFailedTest(contextFiles, existingSnapshotFile, serializedActual, assertionError)).orElseGet(() -> SnapshotTestResult.of(contextFiles, status, existingSnapshotFile, serializedActual));
        }
        return SnapshotTestResult.of(contextFiles, status, actualSnapshotFile, serializedActual);
    }

    private SnapshotTestResult.SnapshotStatus determineStatus(SnapshotAssertionInput assertionInput) {
        if (assertionInput.isDisableAssertion()) {
            return SnapshotTestResult.SnapshotStatus.DISABLED;
        }
        if (!assertionInput.isSnapshotFileAreadyExists()) {
            return SnapshotTestResult.SnapshotStatus.CREATED_INITIALLY;
        }
        if (assertionInput.isForceUpdateSnapshots()) {
            return SnapshotTestResult.SnapshotStatus.UPDATED_FORCEFULLY;
        }
        return SnapshotTestResult.SnapshotStatus.ASSERTED;
    }

    private Optional<Throwable> compareTestResults(StructuralAssertions structuralAssertions, String storedSnapshot, String serializedActual, Path snapshotFile, int lineNumberOffset, int contextLines) {
        try {
            structuralAssertions.assertEquals(storedSnapshot, serializedActual);
            return Optional.empty();
        }
        catch (AssertionError e) {
            AssertionError diffableAssertionError = this.toDiffableAssertionError(e, serializedActual, storedSnapshot, snapshotFile, lineNumberOffset, contextLines);
            return Optional.of(diffableAssertionError);
        }
        catch (SnapshotException e) {
            return Optional.of(e);
        }
        catch (Exception e) {
            return Optional.of(new SnapshotException(e));
        }
    }

    private AssertionError toDiffableAssertionError(AssertionError original, String serializedActual, String storedSnapshot, Path snapshotFile, int lineNumberOffset, int contextLines) {
        StringBuilder assertionMessage = new StringBuilder();
        if (((Throwable)((Object)original)).getMessage() != null) {
            assertionMessage.append(((Throwable)((Object)original)).getMessage());
        }
        assertionMessage.append(System.lineSeparator()).append(System.lineSeparator()).append("Snapshot location:").append(System.lineSeparator()).append("\t").append(snapshotFile.toString()).append(System.lineSeparator());
        TextDiff testDiff = this.determineDiff(original, storedSnapshot, serializedActual);
        if (testDiff.differencesDetected()) {
            assertionMessage.append(System.lineSeparator()).append("Full unified diff of actual result and stored snapshot:").append(System.lineSeparator()).append(testDiff.renderDiffWithOffsetAndContextLines(lineNumberOffset, contextLines));
        }
        AssertionFailedError error = new AssertionFailedError(assertionMessage.toString(), (Object)storedSnapshot, (Object)serializedActual, ((Throwable)((Object)original)).getCause());
        return error;
    }

    private TextDiff determineDiff(AssertionError original, String storedSnapshot, String serializedActual) {
        if (original instanceof TextDiffAssertionError) {
            return ((TextDiffAssertionError)original).textDiff();
        }
        return TextDiff.compare(TextDiff.Settings.defaultSettings().withInlineOpeningChangeMarker("~~~~").withInlineClosingChangeMarker("~~~~"), storedSnapshot, serializedActual);
    }
}

