/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.impl;

import de.skuzzle.test.snapshots.ContextFiles;
import de.skuzzle.test.snapshots.SnapshotFile;
import de.skuzzle.test.snapshots.io.FileName;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Method;
import java.nio.file.Path;

final class InternalSnapshotNaming {
    InternalSnapshotNaming() {
    }

    public static String getSnapshotFileName(String snapshotName) {
        return snapshotName + ".snapshot";
    }

    public static String getSnapshotFileNameActual(String snapshotName) {
        return snapshotName + ".snapshot_actual";
    }

    public static String getSnapshotFileNameRaw(String snapshotName) {
        return snapshotName + ".snapshot_raw";
    }

    public static boolean isSnapshotFile(Path path) {
        return path.getFileName().toString().endsWith(".snapshot");
    }

    public static ContextFiles contextFilesForSnapshotFile(Path snapshotFile) {
        String snapshotFileName = FileName.fromPath((Path)snapshotFile);
        String actualFileName = InternalSnapshotNaming.getSnapshotFileNameActual(snapshotFileName);
        String rawFileName = InternalSnapshotNaming.getSnapshotFileNameRaw(snapshotFileName);
        Path snapshotDirectory = snapshotFile.getParent();
        return ContextFiles.of(snapshotDirectory.resolve(snapshotFileName), snapshotDirectory.resolve(actualFileName), snapshotDirectory.resolve(rawFileName));
    }

    public static boolean isSnapshotFileForMethod(Path path, Method testMethod) {
        try {
            return SnapshotFile.fromSnapshotFile(path).header().get("test-method").equals(testMethod.getName());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error determining snapshot header for method " + testMethod + " from snapshot file at " + path, e);
        }
    }
}

