/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.impl;

import de.skuzzle.test.snapshots.ContextFiles;
import de.skuzzle.test.snapshots.SnapshotTestResult;
import de.skuzzle.test.snapshots.impl.InternalSnapshotNaming;
import de.skuzzle.test.snapshots.impl.OrphanDetectionResult;
import de.skuzzle.test.snapshots.io.UncheckedIO;
import de.skuzzle.test.snapshots.validation.Arguments;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class DynamicOrphanedSnapshotsDetector {
    private final Set<Method> failedOrSkippedTestMethods = new HashSet<Method>();
    private final List<SnapshotTestResult> results = new ArrayList<SnapshotTestResult>();

    DynamicOrphanedSnapshotsDetector() {
    }

    public void addResult(SnapshotTestResult result) {
        this.results.add(result);
    }

    public void addFailedOrSkippedTestMethod(Method testMethod) {
        this.failedOrSkippedTestMethods.add((Method)Arguments.requireNonNull((Object)testMethod));
    }

    private Stream<Path> snapshotDirectories(Path globalSnapshotDirectory) {
        return Stream.concat(Stream.of(globalSnapshotDirectory), this.results.stream().map(SnapshotTestResult::contextFiles).map(ContextFiles::snapshotFile).map(Path::getParent)).filter(x$0 -> Files.exists(x$0, new LinkOption[0]));
    }

    public Stream<OrphanDetectionResult> detectOrphans(Path globalSnapshotDirectory) {
        try (Stream files = this.snapshotDirectories(globalSnapshotDirectory).flatMap(UncheckedIO::list);){
            Stream<OrphanDetectionResult> stream = files.filter(this::isSnapshotFile).map(this::isOrphanedSnapshot).collect(Collectors.toList()).stream();
            return stream;
        }
    }

    private boolean isSnapshotFile(Path potentialSnapshotFile) {
        return InternalSnapshotNaming.isSnapshotFile(potentialSnapshotFile);
    }

    private OrphanDetectionResult isOrphanedSnapshot(Path snapshotFile) {
        boolean containedInTest;
        OrphanDetectionResult.OrphanStatus result = this.pertainsToDisabledAssertion(snapshotFile) ? OrphanDetectionResult.OrphanStatus.ACTIVE : (this.pertainsToFailedOrSkippedTest(snapshotFile) ? OrphanDetectionResult.OrphanStatus.UNSURE : ((containedInTest = this.testResultsContain(snapshotFile)) ? OrphanDetectionResult.OrphanStatus.ACTIVE : OrphanDetectionResult.OrphanStatus.ORPHAN));
        return new OrphanDetectionResult(this.getClass().getSimpleName(), snapshotFile, result);
    }

    private boolean pertainsToFailedOrSkippedTest(Path snapshotFile) {
        return this.failedOrSkippedTestMethods.stream().anyMatch(failedTestMethod -> InternalSnapshotNaming.isSnapshotFileForMethod(snapshotFile, failedTestMethod));
    }

    private boolean pertainsToDisabledAssertion(Path snapshotFile) {
        return this.results.stream().filter(result -> result.status() == SnapshotTestResult.SnapshotStatus.DISABLED).anyMatch(result -> result.contextFiles().snapshotFile().equals(snapshotFile));
    }

    private boolean testResultsContain(Path snapshotFile) {
        return this.results.stream().map(SnapshotTestResult::contextFiles).map(ContextFiles::snapshotFile).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).anyMatch(snapshotFileFromResult -> UncheckedIO.isSameFile((Path)snapshotFileFromResult, (Path)snapshotFile));
    }
}

