/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.impl;

import de.skuzzle.test.snapshots.DeleteOrphanedSnapshots;
import de.skuzzle.test.snapshots.ForceUpdateSnapshots;
import de.skuzzle.test.snapshots.SnapshotTestOptions;
import de.skuzzle.test.snapshots.impl.DetermineSnapshotDirectory;
import de.skuzzle.test.snapshots.impl.SnapshotConfiguration;
import de.skuzzle.test.snapshots.impl.TestClass;
import de.skuzzle.test.snapshots.validation.Arguments;
import java.lang.reflect.Method;
import java.nio.file.Path;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL, since="1.1.0")
final class DefaultSnapshotConfiguration
implements SnapshotConfiguration {
    private static final String FORCE_UPDATE_SYSTEM_PROPERTY = "forceUpdateSnapshots";
    private static final String DELETE_ORPHANS_SYSTEM_PROPERTY = "deleteOrphanedSnapshots";
    private static final int DEFAULT_CONTEXT_LINES = 5;
    private final TestClass testClass;

    private DefaultSnapshotConfiguration(Class<?> testClass) {
        Arguments.requireNonNull(testClass, (String)"testClass must not be null");
        this.testClass = TestClass.wrap(testClass);
    }

    public static SnapshotConfiguration forTestClass(Class<?> testClass) {
        return new DefaultSnapshotConfiguration(testClass);
    }

    @Override
    public Path determineSnapshotDirectory() {
        return DetermineSnapshotDirectory.forTestclass(this.testClass);
    }

    @Override
    public Class<?> testClass() {
        return this.testClass.testClass();
    }

    @Override
    public boolean isDeleteOrphanedSnapshots() {
        return this.testClass().isAnnotationPresent(DeleteOrphanedSnapshots.class) || System.getProperties().keySet().stream().map(Object::toString).anyMatch(DELETE_ORPHANS_SYSTEM_PROPERTY::equalsIgnoreCase);
    }

    private boolean isForceUpdateSnapshotsGlobal() {
        if (this.testClass().isAnnotationPresent(ForceUpdateSnapshots.class)) {
            return true;
        }
        return System.getProperties().keySet().stream().map(Object::toString).anyMatch(FORCE_UPDATE_SYSTEM_PROPERTY::equalsIgnoreCase);
    }

    @Override
    public boolean isForceUpdateSnapshots(Method testMethod) {
        if (testMethod.isAnnotationPresent(ForceUpdateSnapshots.class)) {
            return true;
        }
        return this.isForceUpdateSnapshotsGlobal();
    }

    private SnapshotTestOptions determineOptions(Method testMethod) {
        SnapshotTestOptions options = testMethod.getAnnotation(SnapshotTestOptions.class);
        if (options != null) {
            return options;
        }
        return this.testClass.getAnnotation(SnapshotTestOptions.class);
    }

    @Override
    public boolean alwaysPersistActualResult(Method testMethod) {
        SnapshotTestOptions snapshotTestOptions = this.determineOptions(testMethod);
        return snapshotTestOptions != null && snapshotTestOptions.alwaysPersistActualResult();
    }

    @Override
    public boolean alwaysPersistRawResult(Method testMethod) {
        SnapshotTestOptions snapshotTestOptions = this.determineOptions(testMethod);
        return snapshotTestOptions != null && snapshotTestOptions.alwaysPersistRawResult();
    }

    @Override
    public int textDiffContextLines(Method testMethod) {
        SnapshotTestOptions snapshotTestOptions = this.determineOptions(testMethod);
        return snapshotTestOptions == null ? 5 : snapshotTestOptions.textDiffContextLines();
    }

    @Override
    public boolean addOffsetToReportedLinenumbers(Method testMethod) {
        SnapshotTestOptions snapshotTestOptions = this.determineOptions(testMethod);
        return snapshotTestOptions == null ? true : snapshotTestOptions.renderLineNumbers() == SnapshotTestOptions.DiffLineNumbers.ACCODRDING_TO_PERSISTED_SNAPSHOT_FILE;
    }

    @Override
    public boolean isSoftAssertions() {
        return false;
    }

    public String toString() {
        return "DefaultSnapshotConfiguration[" + this.testClass.getName() + "]";
    }
}

