/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.impl;

import java.util.List;
import java.util.Optional;

final class AssumptionExceptionDetector {
    private static final List<String> CLASS_NAMES = List.of("org.junit.AssumptionViolatedException", "org.testng.SkipException", "org.opentest4j.TestAbortedException");
    private static final Class<? extends Throwable> EXCEPTION_CLASS;

    AssumptionExceptionDetector() {
    }

    static Optional<Throwable> assumptionFailed(String message) {
        if (!AssumptionExceptionDetector.assumptionsSupported()) {
            return Optional.empty();
        }
        try {
            return Optional.of(EXCEPTION_CLASS.getConstructor(String.class).newInstance(message));
        }
        catch (ReflectiveOperationException e) {
            return Optional.empty();
        }
    }

    private static boolean assumptionsSupported() {
        return EXCEPTION_CLASS != null;
    }

    private static Class<?> tryLoad(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    static {
        Class<?> result = null;
        try {
            for (String className : CLASS_NAMES) {
                Class<?> clazz = AssumptionExceptionDetector.tryLoad(className);
                if (clazz == null) continue;
                result = clazz;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        EXCEPTION_CLASS = result;
    }
}

