/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.data.text;

import com.github.difflib.text.DiffRow;
import de.skuzzle.test.snapshots.data.text.DiffListLookahead;
import de.skuzzle.test.snapshots.data.text.DiffRenderer;
import de.skuzzle.test.snapshots.data.text.LineSeparator;
import java.util.List;

final class UnifiedDiffRenderer
implements DiffRenderer {
    UnifiedDiffRenderer() {
    }

    private String padLeft(String text, int targetWidth) {
        int missingSpaces = targetWidth - text.length();
        return " ".repeat(missingSpaces) + text;
    }

    @Override
    public String renderDiff(List<DiffRow> rows, int contextLines, int lineNumberOffset) {
        int rowCountEstimate = rows.size();
        int rowNumberWidth = Math.max(2, (int)Math.log10(rowCountEstimate) + 1) + 1;
        int expectedLine = 1 + lineNumberOffset;
        int actualLine = 1 + lineNumberOffset;
        StringBuilder b = new StringBuilder();
        int indexOfLastDifference = -1;
        block6: for (int i = 0; i < rows.size(); ++i) {
            DiffRow diffRow = rows.get(i);
            switch (diffRow.getTag()) {
                case EQUAL: {
                    int distanceToPrevDifference;
                    int indexOfNextDifference = DiffListLookahead.indexOfNextNonEqual(rows, i);
                    int distanceToNextDifference = indexOfNextDifference == rows.size() ? Integer.MAX_VALUE : indexOfNextDifference - i - 1;
                    int n = distanceToPrevDifference = indexOfLastDifference == -1 ? Integer.MAX_VALUE : i - indexOfLastDifference - 1;
                    if (distanceToNextDifference < contextLines || distanceToPrevDifference < contextLines) {
                        b.append(this.padLeft("" + expectedLine, rowNumberWidth)).append(this.padLeft("" + actualLine, rowNumberWidth)).append("   ").append(diffRow.getOldLine());
                    } else if (distanceToNextDifference == contextLines || distanceToPrevDifference == contextLines) {
                        b.append("[...]");
                    } else {
                        ++expectedLine;
                        ++actualLine;
                        continue block6;
                    }
                    ++expectedLine;
                    ++actualLine;
                    break;
                }
                case CHANGE: {
                    indexOfLastDifference = i;
                    b.append(this.padLeft("" + expectedLine, rowNumberWidth)).append(" ".repeat(rowNumberWidth)).append(" - ").append(diffRow.getOldLine()).append((Object)LineSeparator.SYSTEM).append(" ".repeat(rowNumberWidth)).append(this.padLeft("" + actualLine, rowNumberWidth)).append(" + ").append(diffRow.getNewLine());
                    ++expectedLine;
                    ++actualLine;
                    break;
                }
                case DELETE: {
                    indexOfLastDifference = i;
                    b.append(this.padLeft("" + expectedLine, rowNumberWidth)).append(" ".repeat(rowNumberWidth)).append(" - ").append(diffRow.getOldLine());
                    ++expectedLine;
                    break;
                }
                case INSERT: {
                    indexOfLastDifference = i;
                    b.append(" ".repeat(rowNumberWidth)).append(this.padLeft("" + actualLine, rowNumberWidth)).append(" + ").append(diffRow.getNewLine());
                    ++actualLine;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (i >= rows.size() - 1) continue;
            b.append((Object)LineSeparator.SYSTEM);
        }
        return b.toString();
    }
}

