/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.data.text;

import de.skuzzle.test.snapshots.StructuredData;
import de.skuzzle.test.snapshots.StructuredDataProvider;
import de.skuzzle.test.snapshots.data.text.DiffRenderer;
import de.skuzzle.test.snapshots.data.text.SplitDiffRenderer;
import de.skuzzle.test.snapshots.data.text.TextDiff;
import de.skuzzle.test.snapshots.data.text.TextDiffStructuralAssertions;
import de.skuzzle.test.snapshots.data.text.UnifiedDiffRenderer;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class TextSnapshot
implements StructuredDataProvider {
    private final TextDiff.Settings settings = TextDiff.Settings.defaultSettings();
    public static final StructuredData text = TextSnapshot.text().withIgnoreWhitespaces(true).withContextLines(Integer.MAX_VALUE).build();

    private TextSnapshot() {
    }

    @API(status=API.Status.STABLE, since="1.4.0")
    public static TextSnapshot text() {
        return new TextSnapshot();
    }

    @API(status=API.Status.STABLE, since="1.4.0")
    public TextSnapshot withIgnoreWhitespaces(boolean ignoreWhitespaces) {
        this.settings.withIgnoreWhitespaces(ignoreWhitespaces);
        return this;
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.5.0")
    public TextSnapshot withContextLines(int contextLines) {
        this.settings.withContextLines(contextLines);
        return this;
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.7.0")
    public TextSnapshot withDiffFormat(DiffFormat diffFormat) {
        this.settings.withDiffRenderer(diffFormat.renderer);
        return this;
    }

    @Override
    public StructuredData build() {
        TextDiffStructuralAssertions structuralAssertions = new TextDiffStructuralAssertions(this.settings);
        return StructuredData.with(Object::toString, structuralAssertions);
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.7.0")
    public static enum DiffFormat {
        UNIFIED(new UnifiedDiffRenderer()),
        SPLIT(new SplitDiffRenderer());

        private final DiffRenderer renderer;

        private DiffFormat(DiffRenderer renderer) {
            this.renderer = renderer;
        }
    }
}

