/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.data.text;

import com.github.difflib.text.DiffRow;
import com.github.difflib.text.DiffRowGenerator;
import de.skuzzle.test.snapshots.data.text.DiffRenderer;
import de.skuzzle.test.snapshots.data.text.LineSeparator;
import de.skuzzle.test.snapshots.data.text.UnifiedDiffRenderer;
import de.skuzzle.test.snapshots.validation.Arguments;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL, since="1.4.0")
public final class TextDiff {
    private final Settings settings;
    private final List<DiffRow> diffRows;
    private final LineSeparator expectedLineSeparator;
    private final LineSeparator actualLineSeparator;

    private TextDiff(Settings settings, List<DiffRow> diffRows, LineSeparator expectedLineSeparator, LineSeparator actualLineSeparator) {
        this.settings = settings;
        this.diffRows = diffRows;
        this.expectedLineSeparator = expectedLineSeparator;
        this.actualLineSeparator = actualLineSeparator;
    }

    public static TextDiff compare(Settings settings, String expected, String actual) {
        Arguments.requireNonNull((Object)(settings != null ? 1 : 0), (String)"settings must not be null");
        Arguments.requireNonNull((Object)expected, (String)"expected String must not be null");
        Arguments.requireNonNull((Object)actual, (String)"actual String must not be null");
        LineSeparator expectedLineSeparator = LineSeparator.determineFrom(expected);
        LineSeparator actualLineSeparator = LineSeparator.determineFrom(actual);
        List diffRows = settings.buildDiffRowGenerator().generateDiffRows(expected.lines().collect(Collectors.toList()), actual.lines().collect(Collectors.toList()));
        return new TextDiff(settings, diffRows, expectedLineSeparator, actualLineSeparator);
    }

    private boolean hasLinebreakDifference() {
        return this.expectedLineSeparator != this.actualLineSeparator && !this.settings.ignoreWhitespaces;
    }

    private boolean hasTextDifference() {
        return this.diffRows.stream().map(DiffRow::getTag).anyMatch(tag -> tag != DiffRow.Tag.EQUAL);
    }

    public boolean differencesDetected() {
        return this.hasLinebreakDifference() || this.hasTextDifference();
    }

    public String renderDiffWithOffsetAndContextLines(int lineNumberOffset, int contextLines) {
        StringBuilder result = new StringBuilder();
        boolean hasTextDifference = this.hasTextDifference();
        boolean hasLinebreakDifference = this.hasLinebreakDifference();
        if (hasLinebreakDifference) {
            result.append("Strings differ in linebreaks. Expected: '").append(this.expectedLineSeparator.displayName()).append("', Actual encountered: '").append(this.actualLineSeparator.displayName()).append("'");
            if (hasTextDifference) {
                result.append((Object)LineSeparator.SYSTEM).append((Object)LineSeparator.SYSTEM);
            }
        }
        if (hasTextDifference) {
            result.append(this.settings.diffRenderer.renderDiff(this.diffRows, contextLines, lineNumberOffset));
        }
        return result.toString();
    }

    public String toString() {
        return this.renderDiffWithOffsetAndContextLines(0, this.settings.contextLines);
    }

    @API(status=API.Status.INTERNAL, since="1.7.0")
    public static final class Settings {
        private boolean ignoreWhitespaces = false;
        private int contextLines = 5;
        private String inlineOpeningChangeMarker = "<<";
        private String inlineClosingChangeMarker = ">>";
        private DiffRenderer diffRenderer = new UnifiedDiffRenderer();

        private Settings() {
        }

        public static Settings defaultSettings() {
            return new Settings();
        }

        public Settings withIgnoreWhitespaces(boolean ignoreWhitespaces) {
            this.ignoreWhitespaces = ignoreWhitespaces;
            return this;
        }

        public Settings withContextLines(int contextLines) {
            Arguments.check((contextLines >= 0 ? 1 : 0) != 0, (String)"contextLines must be a positive integer");
            this.contextLines = contextLines;
            return this;
        }

        public Settings withInlineOpeningChangeMarker(String inlineOpeningChangeMarker) {
            this.inlineOpeningChangeMarker = (String)Arguments.requireNonNull((Object)inlineOpeningChangeMarker, (String)"opening marker must not be null");
            return this;
        }

        public Settings withInlineClosingChangeMarker(String inlineClosingChangeMarker) {
            this.inlineClosingChangeMarker = (String)Arguments.requireNonNull((Object)inlineClosingChangeMarker, (String)"closing marker must not be null");
            return this;
        }

        public Settings withDiffRenderer(DiffRenderer renderer) {
            this.diffRenderer = (DiffRenderer)Arguments.requireNonNull((Object)renderer, (String)"renderer must not be null");
            return this;
        }

        private BiFunction<DiffRow.Tag, Boolean, String> inlineMarker() {
            return (tag, isOpening) -> {
                if (tag != DiffRow.Tag.CHANGE) {
                    return "";
                }
                return isOpening != false ? this.inlineOpeningChangeMarker : this.inlineClosingChangeMarker;
            };
        }

        private DiffRowGenerator buildDiffRowGenerator() {
            return DiffRowGenerator.create().showInlineDiffs(true).lineNormalizer(Function.identity()).inlineDiffByWord(true).ignoreWhiteSpaces(this.ignoreWhitespaces).newTag(this.inlineMarker()).oldTag(this.inlineMarker()).build();
        }
    }
}

