/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.data.text;

import com.github.difflib.text.DiffRow;
import de.skuzzle.test.snapshots.data.text.DiffListLookahead;
import de.skuzzle.test.snapshots.data.text.DiffRenderer;
import de.skuzzle.test.snapshots.data.text.LineSeparator;
import java.util.List;

final class SplitDiffRenderer
implements DiffRenderer {
    private static final String OPERATION_CHANGE = "!";
    private static final String OPERATION_ADD = "+";
    private static final String OPERATION_DELETE = "-";
    private static final String OPERATION_EQUAL = " ";

    SplitDiffRenderer() {
    }

    private String padLeft(String text, int targetWidth) {
        int missingSpaces = targetWidth - text.length();
        return OPERATION_EQUAL.repeat(missingSpaces) + text;
    }

    private String padRight(String text, int targetWidth) {
        int missingSpaces = targetWidth - text.length();
        return text + OPERATION_EQUAL.repeat(missingSpaces);
    }

    private void appendRow(StringBuilder b, int columnWidth, String paddedExpectedLineNumber, String expectedOperation, String expectedLine, String paddedActualLineNumber, String actualOperation, String actualLine) {
        b.append(paddedExpectedLineNumber).append(OPERATION_EQUAL).append(expectedOperation).append(OPERATION_EQUAL).append(this.padRight(expectedLine, columnWidth)).append(" |").append(paddedActualLineNumber).append(OPERATION_EQUAL).append(actualOperation).append(OPERATION_EQUAL).append(actualLine);
    }

    @Override
    public String renderDiff(List<DiffRow> rows, int contextLines, int lineNumberOffset) {
        int columnWidth = rows.stream().map(DiffRow::getOldLine).mapToInt(String::length).max().orElse(80);
        int rowCountEstimate = rows.size();
        int rowNumberWidth = Math.max(2, (int)Math.log10(rowCountEstimate) + 1) + 1;
        int expectedLine = 1 + lineNumberOffset;
        int actualLine = 1 + lineNumberOffset;
        StringBuilder b = new StringBuilder();
        int indexOfLastDifference = -1;
        block6: for (int i = 0; i < rows.size(); ++i) {
            DiffRow diffRow = rows.get(i);
            switch (diffRow.getTag()) {
                case CHANGE: {
                    indexOfLastDifference = i;
                    this.appendRow(b, columnWidth, this.padLeft("" + expectedLine, rowNumberWidth), OPERATION_CHANGE, diffRow.getOldLine(), this.padLeft("" + actualLine, rowNumberWidth), OPERATION_CHANGE, diffRow.getNewLine());
                    ++expectedLine;
                    ++actualLine;
                    break;
                }
                case EQUAL: {
                    int distanceToPrevDifference;
                    int indexOfNextDifference = DiffListLookahead.indexOfNextNonEqual(rows, i);
                    int distanceToNextDifference = indexOfNextDifference == rows.size() ? Integer.MAX_VALUE : indexOfNextDifference - i - 1;
                    int n = distanceToPrevDifference = indexOfLastDifference == -1 ? Integer.MAX_VALUE : i - indexOfLastDifference - 1;
                    if (distanceToNextDifference < contextLines || distanceToPrevDifference < contextLines) {
                        this.appendRow(b, columnWidth, this.padLeft("" + expectedLine, rowNumberWidth), OPERATION_EQUAL, diffRow.getOldLine(), this.padLeft("" + actualLine, rowNumberWidth), OPERATION_EQUAL, diffRow.getNewLine());
                    } else if (distanceToNextDifference == contextLines || distanceToPrevDifference == contextLines) {
                        b.append("[...]");
                    } else {
                        ++expectedLine;
                        ++actualLine;
                        continue block6;
                    }
                    ++expectedLine;
                    ++actualLine;
                    break;
                }
                case DELETE: {
                    indexOfLastDifference = i;
                    this.appendRow(b, columnWidth, this.padLeft("" + expectedLine, rowNumberWidth), OPERATION_DELETE, diffRow.getOldLine(), OPERATION_EQUAL.repeat(rowNumberWidth), OPERATION_EQUAL, diffRow.getNewLine());
                    ++expectedLine;
                    break;
                }
                case INSERT: {
                    indexOfLastDifference = i;
                    this.appendRow(b, columnWidth, OPERATION_EQUAL.repeat(rowNumberWidth), OPERATION_EQUAL, diffRow.getOldLine(), this.padLeft("" + actualLine, rowNumberWidth), OPERATION_ADD, diffRow.getNewLine());
                    ++actualLine;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (i >= rows.size() - 1) continue;
            b.append((Object)LineSeparator.SYSTEM);
        }
        return b.toString();
    }
}

