/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.data.text;

import java.util.stream.Collectors;

enum LineSeparator {
    CRLF("\r\n", "\\r\\n"),
    LF("\n", "\\n"),
    CR("\r", "\\r"),
    DEFAULT("\n", "\\n"),
    SYSTEM(System.lineSeparator(), System.lineSeparator().replace("\r", "\\r").replace("\n", "\\n"));

    private final String characters;
    private final String displayName;

    private LineSeparator(String characters, String displayName) {
        this.characters = characters;
        this.displayName = displayName;
    }

    public static LineSeparator determineFrom(String s) {
        for (LineSeparator lineSeparator : LineSeparator.values()) {
            if (!lineSeparator.existsIn(s)) continue;
            return lineSeparator;
        }
        return DEFAULT;
    }

    private boolean existsIn(String s) {
        return s.indexOf(this.characters) >= 0;
    }

    public String displayName() {
        return this.name() + "(" + this.displayName + ")";
    }

    public boolean endsWith(String s) {
        return s.endsWith(this.characters);
    }

    public boolean startsWith(String s) {
        return s.startsWith(this.characters);
    }

    public String convert(String s) {
        return s.lines().collect(Collectors.joining(this.characters));
    }

    public String toString() {
        return this.characters;
    }
}

