/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots;

import de.skuzzle.test.snapshots.validation.Arguments;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL, since="1.1.0")
public interface SnapshotNaming {
    public static SnapshotNaming defaultNaming() {
        return (testMethod, counter) -> testMethod.getName() + "_" + counter;
    }

    public static SnapshotNaming constant(String snapshotName) {
        Arguments.requireNonNull((Object)snapshotName, (String)"snapshotName must not be null");
        return (testMethod, counter) -> snapshotName;
    }

    public static SnapshotNaming withParameters(Object parameter1, Object ... furtherParameters) {
        Arguments.requireNonNull((Object)parameter1, (String)"parameter must not be null");
        return (testMethod, counter) -> {
            String parameterPart = Stream.concat(Stream.of(parameter1), Arrays.stream(furtherParameters)).map(Object::toString).collect(Collectors.joining("_"));
            return testMethod.getName() + "_" + counter + "_" + parameterPart;
        };
    }

    public String determineSnapshotName(Method var1, int var2);
}

