/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.impl;

import de.skuzzle.test.snapshots.ForceUpdateSnapshots;
import de.skuzzle.test.snapshots.SnapshotDsl;
import de.skuzzle.test.snapshots.SnapshotTestOptions;
import de.skuzzle.test.snapshots.SnapshotTestResult;
import de.skuzzle.test.snapshots.StructuredDataProvider;
import de.skuzzle.test.snapshots.data.text.TextSnapshot;
import de.skuzzle.test.snapshots.impl.MetaTest;
import de.skuzzle.test.snapshots.junit5.EnableSnapshotTests;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class FailingSnapshotTestsNew {
    private final MetaTest frameworkTest = new MetaTest();

    @Test
    void testDetectIncompleteDSLReuse() throws Exception {
        this.frameworkTest.expectTestcase(DetectIncompleteDslReuse.class).toAllFailWithExceptionWhich(matches -> ((AbstractThrowableAssert)matches.isInstanceOf(IllegalStateException.class)).hasMessageContaining("Detected illegal reuse of a DSL stage"));
    }

    @Test
    void testDetectIncompleteDSLUsage() throws Exception {
        this.frameworkTest.expectTestcase(DetectIncompleteDslUsage.class).toAllFailWithExceptionWhich(matches -> ((AbstractThrowableAssert)matches.isInstanceOf(IllegalStateException.class)).hasMessageContaining("Detected incomplete DSL usage"));
    }

    @Test
    void testFailBecauseOfNullInputSnapshotAlreadyExists() throws Throwable {
        ((AbstractThrowableAssert)this.frameworkTest.expectTestcase(FailBecauseOfNullInputSnapshotAlreadyExists.class).toFailWithExceptionWhich().isInstanceOf(AssertionError.class)).hasMessage("Expected actual not to be null but to match stored snapshot:\n\nsnapshot text");
    }

    @Test
    void testFailBecauseOfNullInputJustUpdateSnapshot() throws Throwable {
        ((AbstractThrowableAssert)this.frameworkTest.expectTestcase(FailBecauseOfNullInputJustUpdateSnapshot.class).toFailWithExceptionWhich().isInstanceOf(AssertionError.class)).hasMessage("Expected actual not to be null in order to take initial snapshot");
    }

    @Test
    void testFailBecauseOfNullInputInitialSnapshot() throws Throwable {
        ((AbstractThrowableAssert)this.frameworkTest.expectTestcase(FailBecauseOfNullInputInitialSnapshot.class).toFailWithExceptionWhich().isInstanceOf(AssertionError.class)).hasMessage("Expected actual not to be null in order to take initial snapshot");
    }

    @Test
    void testFailBecauseForceUpdateFromAnnotationOnTestClass() throws Throwable {
        ((AbstractThrowableAssert)this.frameworkTest.expectTestcase(FailBecauseForceUpdateFromAnnotationOnTestClass.class).toFailWithExceptionWhich().isInstanceOf(AssertionError.class)).hasMessage(String.format("Snapshots have been updated forcefully.%nRemove 'updateSnapshots = true' attribute from your test class and calls to 'justUpdateSnapshot()' and run the tests again.", new Object[0]));
    }

    @Test
    void testFailBecauseJustUpdate() throws Exception {
        ((AbstractThrowableAssert)this.frameworkTest.expectTestcase(FailBecauseJustUpdate.class).toFailWithExceptionWhich().isInstanceOf(AssertionError.class)).hasMessage(String.format("Snapshots have been updated forcefully.%nRemove 'updateSnapshots = true' attribute from your test class and calls to 'justUpdateSnapshot()' and run the tests again.", new Object[0]));
    }

    @Test
    void testFailBecauseForceUpdateAnnotationOnTestMethod() throws Exception {
        ((AbstractThrowableAssert)this.frameworkTest.expectTestcase(FailBecauseForceUpdateAnnotationOnTestMethod.class).toFailWithExceptionWhich().isInstanceOf(AssertionError.class)).hasMessage(String.format("Snapshots have been updated forcefully.%nRemove 'updateSnapshots = true' attribute from your test class and calls to 'justUpdateSnapshot()' and run the tests again.", new Object[0]));
    }

    @Test
    void testFailBecauseSnapshotMismatch() throws Throwable {
        ((AbstractThrowableAssert)this.frameworkTest.expectTestcase(FailBecauseSnapshotMismatch.class).toFailWithExceptionWhich().isInstanceOf(AssertionError.class)).hasMessage(String.format("Stored snapshot doesn't match actual result.%n%nSnapshot location:%n\t%s%n%nFull unified diff of actual result and stored snapshot:%n  7    - test%n     7 + NOT test", Path.of("src/test/resources/de/skuzzle/test/snapshots/impl/FailingSnapshotTestsNew$FailBecauseSnapshotMismatch_snapshots/testWithSnapshot_0.snapshot", new String[0])));
    }

    @Test
    void testFailBecauseSnapshotMismatchWithRawLinenumbers() throws Throwable {
        ((AbstractThrowableAssert)this.frameworkTest.expectTestcase(FailBecauseSnapshotMismatchWithRawLinenumbers.class).toFailWithExceptionWhich().isInstanceOf(AssertionError.class)).hasMessage(String.format("Stored snapshot doesn't match actual result.%n%nSnapshot location:%n\t%s%n%nFull unified diff of actual result and stored snapshot:%n  1    - test%n     1 + NOT test", Path.of("src/test/resources/de/skuzzle/test/snapshots/impl/FailingSnapshotTestsNew$FailBecauseSnapshotMismatchWithRawLinenumbers_snapshots/testWithSnapshot_0.snapshot", new String[0])));
    }

    @Test
    void testFailBecauseSnapshotMismatchWithWhitespaces() throws Throwable {
        ((AbstractThrowableAssert)this.frameworkTest.expectTestcase(FailBecauseSnapshotMismatchWithWhitespaces.class).toFailWithExceptionWhich().isInstanceOf(AssertionError.class)).hasMessage(String.format("Stored snapshot doesn't match actual result.%n%nSnapshot location:%n\t%s%n%nFull unified diff of actual result and stored snapshot:%nStrings differ in linebreaks. Expected: 'CRLF(\\r\\n)', Actual encountered: 'LF(\\n)'%n%n  7    - <<line2>>%n     7 + <<line4>>%n  8    - <<line3>>%n     8 + <<line5>>", Path.of("src/test/resources/de/skuzzle/test/snapshots/impl/FailingSnapshotTestsNew$FailBecauseSnapshotMismatchWithWhitespaces_snapshots/testWithSnapshot_0.snapshot", new String[0])));
    }

    @Test
    void testFailBecauseInitial() throws Throwable {
        ((AbstractThrowableAssert)this.frameworkTest.expectTestcase(FailBecauseInitial.class).toFailWithExceptionWhich().isInstanceOf(AssertionError.class)).hasMessage(String.format("Snapshots have been created the first time.%nRun the test again and you should see it succeed.", new Object[0]));
    }

    @Test
    void testMultipleAssertions() throws Exception {
        this.frameworkTest.expectTestcase(MultipleAssertions.class).toFailWithExceptionWhich().isInstanceOf(AssertionError.class);
    }

    @Test
    void testWhitespacesDuringTextCompare() throws Exception {
        this.frameworkTest.expectTestcase(WhitespacesDuringTextCompare.class).toFailWithExceptionWhich().isInstanceOf(AssertionError.class);
    }

    @Test
    void testWhitespacesDuringStructureTextCompare() throws Exception {
        this.frameworkTest.expectTestcase(WhitespacesDuringStructureTextCompare.class).toFailWithExceptionWhich().isInstanceOf(AssertionError.class);
    }

    @EnableSnapshotTests
    static class WhitespacesDuringStructureTextCompare {
        WhitespacesDuringStructureTextCompare() {
        }

        @Test
        void testWithSnapshot(SnapshotDsl.Snapshot snapshot) throws Throwable {
            MetaTest.assumeMetaTest();
            snapshot.assertThat((Object)"   test   ").as((StructuredDataProvider)TextSnapshot.text().withIgnoreWhitespaces(false)).matchesSnapshotStructure();
        }
    }

    @EnableSnapshotTests
    static class WhitespacesDuringTextCompare {
        WhitespacesDuringTextCompare() {
        }

        @Test
        void testWithSnapshot(SnapshotDsl.Snapshot snapshot) throws Throwable {
            MetaTest.assumeMetaTest();
            snapshot.assertThat((Object)"   test   ").as((StructuredDataProvider)TextSnapshot.text().withIgnoreWhitespaces(false)).matchesSnapshotText();
        }
    }

    @EnableSnapshotTests
    static class MultipleAssertions {
        MultipleAssertions() {
        }

        @Test
        void testWithSnapshot(SnapshotDsl.Snapshot snapshot) throws Throwable {
            MetaTest.assumeMetaTest();
            snapshot.assertThat((Object)"test").asText().matchesSnapshotText();
            snapshot.assertThat((Object)"test2").asText().matchesSnapshotText();
        }
    }

    @EnableSnapshotTests
    static class FailBecauseInitial {
        FailBecauseInitial() {
        }

        @Test
        void testWithSnapshot(SnapshotDsl.Snapshot snapshot) throws Throwable {
            MetaTest.assumeMetaTest();
            SnapshotTestResult snapshotResult = snapshot.assertThat((Object)"test").asText().matchesSnapshotText();
            snapshotResult.deleteSnapshot();
            Assertions.assertThat((Comparable)snapshotResult.status()).isEqualTo((Object)SnapshotTestResult.SnapshotStatus.CREATED_INITIALLY);
        }
    }

    @EnableSnapshotTests
    static class FailBecauseSnapshotMismatchWithWhitespaces {
        FailBecauseSnapshotMismatchWithWhitespaces() {
        }

        @Test
        void testWithSnapshot(SnapshotDsl.Snapshot snapshot) throws Throwable {
            MetaTest.assumeMetaTest();
            SnapshotTestResult snapshotResult = snapshot.assertThat((Object)"line4\nline5").as((StructuredDataProvider)TextSnapshot.text().withIgnoreWhitespaces(false).withContextLines(5)).matchesSnapshotText();
            Assertions.assertThat((Comparable)snapshotResult.status()).isEqualTo((Object)SnapshotTestResult.SnapshotStatus.ASSERTED);
        }
    }

    @EnableSnapshotTests
    static class FailBecauseSnapshotMismatchWithRawLinenumbers {
        FailBecauseSnapshotMismatchWithRawLinenumbers() {
        }

        @Test
        @SnapshotTestOptions(renderLineNumbers=SnapshotTestOptions.DiffLineNumbers.ACCORDING_TO_RAW_DATA)
        void testWithSnapshot(SnapshotDsl.Snapshot snapshot) throws Throwable {
            MetaTest.assumeMetaTest();
            SnapshotTestResult snapshotResult = snapshot.assertThat((Object)"NOT test").asText().matchesSnapshotText();
            Assertions.assertThat((Comparable)snapshotResult.status()).isEqualTo((Object)SnapshotTestResult.SnapshotStatus.ASSERTED);
        }
    }

    @EnableSnapshotTests
    static class FailBecauseSnapshotMismatch {
        FailBecauseSnapshotMismatch() {
        }

        @Test
        void testWithSnapshot(SnapshotDsl.Snapshot snapshot) throws Throwable {
            MetaTest.assumeMetaTest();
            SnapshotTestResult snapshotResult = snapshot.assertThat((Object)"NOT test").asText().matchesSnapshotText();
            Assertions.assertThat((Comparable)snapshotResult.status()).isEqualTo((Object)SnapshotTestResult.SnapshotStatus.ASSERTED);
        }
    }

    @EnableSnapshotTests
    static class FailBecauseForceUpdateAnnotationOnTestMethod {
        FailBecauseForceUpdateAnnotationOnTestMethod() {
        }

        @Test
        @ForceUpdateSnapshots
        void testWithSnapshot(SnapshotDsl.Snapshot snapshot) throws Throwable {
            MetaTest.assumeMetaTest();
            SnapshotTestResult snapshotResult = snapshot.assertThat((Object)"test").asText().matchesSnapshotText();
            Assertions.assertThat((Comparable)snapshotResult.status()).isEqualTo((Object)SnapshotTestResult.SnapshotStatus.UPDATED_FORCEFULLY);
        }
    }

    @EnableSnapshotTests
    static class FailBecauseJustUpdate {
        FailBecauseJustUpdate() {
        }

        @Test
        void testWithSnapshot(SnapshotDsl.Snapshot snapshot) throws Throwable {
            MetaTest.assumeMetaTest();
            SnapshotTestResult snapshotResult = snapshot.assertThat((Object)"test").asText().justUpdateSnapshot();
            Assertions.assertThat((Comparable)snapshotResult.status()).isEqualTo((Object)SnapshotTestResult.SnapshotStatus.UPDATED_FORCEFULLY);
        }
    }

    @EnableSnapshotTests
    @ForceUpdateSnapshots
    static class FailBecauseForceUpdateFromAnnotationOnTestClass {
        FailBecauseForceUpdateFromAnnotationOnTestClass() {
        }

        @Test
        void testWithSnapshot(SnapshotDsl.Snapshot snapshot) throws Throwable {
            MetaTest.assumeMetaTest();
            SnapshotTestResult snapshotResult = snapshot.assertThat((Object)"test").asText().matchesSnapshotText();
            Assertions.assertThat((Comparable)snapshotResult.status()).isEqualTo((Object)SnapshotTestResult.SnapshotStatus.UPDATED_FORCEFULLY);
        }
    }

    @EnableSnapshotTests
    static class FailBecauseOfNullInputInitialSnapshot {
        FailBecauseOfNullInputInitialSnapshot() {
        }

        @Test
        void testPassNullToSnapshot(SnapshotDsl.Snapshot snapshot) throws Exception {
            MetaTest.assumeMetaTest();
            snapshot.assertThat(null).asText().matchesSnapshotText();
        }
    }

    @EnableSnapshotTests
    static class FailBecauseOfNullInputJustUpdateSnapshot {
        FailBecauseOfNullInputJustUpdateSnapshot() {
        }

        @Test
        void testPassNullToSnapshot(SnapshotDsl.Snapshot snapshot) throws Exception {
            MetaTest.assumeMetaTest();
            snapshot.assertThat(null).asText().justUpdateSnapshot();
        }
    }

    @EnableSnapshotTests
    static class FailBecauseOfNullInputSnapshotAlreadyExists {
        FailBecauseOfNullInputSnapshotAlreadyExists() {
        }

        @Test
        void testPassNullToSnapshot(SnapshotDsl.Snapshot snapshot) throws Exception {
            MetaTest.assumeMetaTest();
            snapshot.assertThat(null).asText().matchesSnapshotText();
        }
    }

    @EnableSnapshotTests
    static class DetectIncompleteDslUsage {
        DetectIncompleteDslUsage() {
        }

        @Test
        void testOnlyAssert(SnapshotDsl.Snapshot snapshot) throws Exception {
            MetaTest.assumeMetaTest();
            snapshot.assertThat((Object)"");
        }

        @Test
        void testOnlyDirectory(SnapshotDsl.Snapshot snapshot) throws Exception {
            MetaTest.assumeMetaTest();
            snapshot.in(Paths.get("/", new String[0]));
        }

        @Test
        void testOnlyName(SnapshotDsl.Snapshot snapshot) throws Exception {
            MetaTest.assumeMetaTest();
            snapshot.named("whatever");
        }

        @Test
        void testNoTerminalOp(SnapshotDsl.Snapshot snapshot) throws Exception {
            MetaTest.assumeMetaTest();
            snapshot.in(Paths.get("/", new String[0])).named("whatever").assertThat((Object)"").as(Object::toString);
        }
    }

    @EnableSnapshotTests
    static class DetectIncompleteDslReuse {
        DetectIncompleteDslReuse() {
        }

        @Test
        void testIllegalReuse(SnapshotDsl.Snapshot snapshot) throws Exception {
            MetaTest.assumeMetaTest();
            snapshot.assertThat((Object)"");
            snapshot.assertThat((Object)"");
        }
    }
}

