/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.impl;

import de.skuzzle.test.snapshots.EnableSnapshotTests;
import de.skuzzle.test.snapshots.SnapshotDirectory;
import de.skuzzle.test.snapshots.SnapshotDirectoryStrategy;
import de.skuzzle.test.snapshots.SnapshotException;
import de.skuzzle.test.snapshots.impl.DetermineSnapshotDirectory;
import de.skuzzle.test.snapshots.io.DirectoryResolver;
import java.nio.file.Path;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DetermineSnapshotDirectoryLegacyTest {
    DetermineSnapshotDirectoryLegacyTest() {
    }

    @Test
    void testDirectoryFromLegacy() throws Exception {
        Path snapshotDirectory = DetermineSnapshotDirectory.forTestclass(Legacy.class);
        Assertions.assertThat((Path)snapshotDirectory).isEqualTo((Object)DirectoryResolver.resolve((String)"test"));
    }

    @Test
    void legacy_and_new_annotation_should_raise_exception() throws Exception {
        Assertions.assertThatExceptionOfType(IllegalStateException.class).isThrownBy(() -> DetermineSnapshotDirectory.forTestclass(LegacyAndNewAnnotation.class));
    }

    @Test
    void empty_snapshot_directory_annotation_should_raise_exception() throws Exception {
        Assertions.assertThatExceptionOfType(IllegalStateException.class).isThrownBy(() -> DetermineSnapshotDirectory.forTestclass(EmptyAnnotation.class));
    }

    @Test
    void testResolveDefaultDirectory() throws Exception {
        Path snapshotDirectory = DetermineSnapshotDirectory.forTestclass(DefaultSnapshotDirectory.class);
        Assertions.assertThat((Path)snapshotDirectory).isEqualTo((Object)DirectoryResolver.resolve((String)(DefaultSnapshotDirectory.class.getName().replace('.', '/') + "_snapshots")));
    }

    @Test
    void testResolveDirectoryFromAnnotationString() throws Exception {
        Path snapshotDirectory = DetermineSnapshotDirectory.forTestclass(FromAnnotationString.class);
        Assertions.assertThat((Path)snapshotDirectory).isEqualTo((Object)DirectoryResolver.resolve((String)"test"));
    }

    @Test
    void testResolveDirectoryFromStrategy() throws Exception {
        Path snapshotDirectory = DetermineSnapshotDirectory.forTestclass(FromStrategy.class);
        Assertions.assertThat((Path)snapshotDirectory).isEqualTo((Object)Path.of("directory", new String[0]));
    }

    public static class SimpleTestSnapshotDirectoryStrategy
    implements SnapshotDirectoryStrategy {
        public Path determineSnapshotDirectory(Class<?> testClass, SnapshotDirectory directory) throws SnapshotException {
            return Path.of(directory.value(), new String[0]);
        }
    }

    @EnableSnapshotTests
    @SnapshotDirectory(value="directory", determinedBy=SimpleTestSnapshotDirectoryStrategy.class)
    private static class FromStrategy {
        private FromStrategy() {
        }
    }

    @EnableSnapshotTests
    @SnapshotDirectory(value="test")
    private static class FromAnnotationString {
        private FromAnnotationString() {
        }
    }

    @EnableSnapshotTests
    private static class DefaultSnapshotDirectory {
        private DefaultSnapshotDirectory() {
        }
    }

    @EnableSnapshotTests
    @SnapshotDirectory
    private static class EmptyAnnotation {
        private EmptyAnnotation() {
        }
    }

    @EnableSnapshotTests(snapshotDirectory="test")
    @SnapshotDirectory(value="test")
    private static class LegacyAndNewAnnotation {
        private LegacyAndNewAnnotation() {
        }
    }

    @EnableSnapshotTests(snapshotDirectory="test")
    private static class Legacy {
        private Legacy() {
        }
    }
}

