/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.data.text;

import de.skuzzle.test.snapshots.SnapshotDsl;
import de.skuzzle.test.snapshots.SnapshotException;
import de.skuzzle.test.snapshots.SnapshotSerializer;
import de.skuzzle.test.snapshots.data.text.DiffRenderer;
import de.skuzzle.test.snapshots.data.text.LineSeparator;
import de.skuzzle.test.snapshots.data.text.SplitDiffRenderer;
import de.skuzzle.test.snapshots.data.text.TextDiff;
import de.skuzzle.test.snapshots.junit5.EnableSnapshotTests;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

@EnableSnapshotTests
public class TextDiffTest {
    private final TextDiff.Settings settings = TextDiff.Settings.defaultSettings();
    private final String expected = this.join("Some unchanged lines1", "Some unchanged lines2", "Some unchanged lines3", "Some unchanged lines4", "Some unchanged lines5", "Some unchanged lines6", "Some unchanged lines7", "Some unchanged lines8", "This is a test senctence.", "This is the second line.", "Some unchanged lines9", "Some unchanged lines10", "Some unchanged lines11", "Some unchanged lines12", "And here is the finish with way more than 80 characters and I'm very curious how this is going to be displayed in split view diff.", "This line is unchanged", "Some unchanged lines13", "Some unchanged lines14", "Some unchanged lines15", "Some unchanged lines16", "Some unchanged lines17", "Some unchanged lines18", "Some unchanged lines19", "Some unchanged lines20", "Another difference", "Some unchanged lines21", "Some unchanged lines22", "Some unchanged lines23", "Some unchanged lines24");
    private final String actual = this.join("Some unchanged lines1", "Some unchanged lines2", "Some unchanged lines3", "Some unchanged lines4", "Some unchanged lines5", "Some unchanged lines6", "Some unchanged lines7", "Some unchanged lines8", "This is a test for diffutils.", "This is the second line.", "Some unchanged lines9", "Some unchanged lines10", "Some unchanged lines11", "Some unchanged lines12", "This line is unchanged", "This line has been added", "Some unchanged lines13", "Some unchanged lines14", "Some unchanged lines15", "Some unchanged lines16", "Some unchanged lines17", "Some unchanged lines18", "Some unchanged lines19", "Some unchanged lines20", "This has changed", "Some unchanged lines21", "Some unchanged lines22", "Some unchanged lines23", "Some unchanged lines24");

    private String join(String ... lines) {
        return Arrays.stream(lines).collect(Collectors.joining("\n"));
    }

    @Test
    void testRenderUnifiedDiffWithRawLinenumbers(SnapshotDsl.Snapshot snapshot) throws Exception {
        TextDiff textDiff = TextDiff.compare((TextDiff.Settings)TextDiff.Settings.defaultSettings().withContextLines(3), (String)this.expected, (String)this.actual);
        snapshot.assertThat((Object)textDiff).asText().matchesSnapshotText();
    }

    @Test
    void testRenderUnifiedDiffWithLinenumberOffset(SnapshotDsl.Snapshot snapshot) throws Exception {
        TextDiff textDiff = TextDiff.compare((TextDiff.Settings)TextDiff.Settings.defaultSettings().withContextLines(3), (String)this.expected, (String)this.actual);
        snapshot.assertThat((Object)textDiff).as(this.diffWithOffset(5)).matchesSnapshotText();
    }

    @Test
    void testRenderSplitDiffWithRawLinenumbers(SnapshotDsl.Snapshot snapshot) throws Exception {
        TextDiff textDiff = TextDiff.compare((TextDiff.Settings)TextDiff.Settings.defaultSettings().withContextLines(3).withDiffRenderer((DiffRenderer)new SplitDiffRenderer()), (String)this.expected, (String)this.actual);
        snapshot.assertThat((Object)textDiff).asText().matchesSnapshotText();
    }

    @Test
    void testRenderSplitDiffWithLinenumberOffset(SnapshotDsl.Snapshot snapshot) throws Exception {
        TextDiff textDiff = TextDiff.compare((TextDiff.Settings)TextDiff.Settings.defaultSettings().withContextLines(3).withDiffRenderer((DiffRenderer)new SplitDiffRenderer()), (String)this.expected, (String)this.actual);
        snapshot.assertThat((Object)textDiff).as(this.diffWithOffset(5)).matchesSnapshotText();
    }

    private SnapshotSerializer diffWithOffset(final int lineNumberOffset) {
        return new SnapshotSerializer(){

            public String serialize(Object testResult) throws SnapshotException {
                return ((TextDiff)testResult).renderDiffWithOffset(lineNumberOffset);
            }
        };
    }

    @Nested
    class WithObeyWhitespaces {
        WithObeyWhitespaces() {
            TextDiffTest.this.settings.withIgnoreWhitespaces(false);
        }

        @Test
        void testSingleLineRemoved() throws Exception {
            TextDiff textDiff = TextDiff.compare((TextDiff.Settings)TextDiffTest.this.settings, (String)"Just a single line", (String)"");
            Assertions.assertThat((boolean)textDiff.differencesDetected()).isTrue();
            Assertions.assertThat((String)textDiff.toString()).isEqualTo("  1    - Just a single line");
        }

        @Test
        void testSingleLineAdded() throws Exception {
            TextDiff textDiff = TextDiff.compare((TextDiff.Settings)TextDiffTest.this.settings, (String)"", (String)"Just a single line");
            Assertions.assertThat((boolean)textDiff.differencesDetected()).isTrue();
            Assertions.assertThat((String)textDiff.toString()).isEqualTo("     1 + Just a single line");
        }

        @Test
        void testWhitespaceChangeWithinSingleLine() throws Exception {
            TextDiff textDiff = TextDiff.compare((TextDiff.Settings)TextDiffTest.this.settings, (String)"Just a single     line", (String)"Just a single line");
            Assertions.assertThat((boolean)textDiff.differencesDetected()).isTrue();
            Assertions.assertThat((String)textDiff.toString()).isEqualTo(LineSeparator.SYSTEM.convert("  1    - Just a single<<     >>line\n     1 + Just a single<< >>line"));
        }

        @Test
        void testLinebreakChangeObeyWhitespaces() throws Exception {
            TextDiff textDiff = TextDiff.compare((TextDiff.Settings)TextDiffTest.this.settings, (String)"line1\nline2", (String)"line1\r\nline2");
            Assertions.assertThat((boolean)textDiff.differencesDetected()).isTrue();
            Assertions.assertThat((String)textDiff.toString()).isEqualTo("Strings differ in linebreaks. Expected: 'LF(\\n)', Actual encountered: 'CRLF(\\r\\n)'");
        }
    }

    @Nested
    class WithIgnoreWhitespaces {
        WithIgnoreWhitespaces() {
            TextDiffTest.this.settings.withIgnoreWhitespaces(true);
        }

        @Test
        void testMultipleLinesAdded() throws Exception {
            TextDiff textDiff = TextDiff.compare((TextDiff.Settings)TextDiffTest.this.settings, (String)TextDiffTest.this.join("line1", "line5"), (String)TextDiffTest.this.join("line1", "line2", "line3", "line4", "line5"));
            Assertions.assertThat((boolean)textDiff.differencesDetected()).isTrue();
            Assertions.assertThat((String)textDiff.toString()).isEqualTo(LineSeparator.SYSTEM.convert("  1  1   line1\n     2 + line2\n     3 + line3\n     4 + line4\n  2  5   line5"));
        }

        @Test
        void testMultipleLinesDeleted() throws Exception {
            TextDiff textDiff = TextDiff.compare((TextDiff.Settings)TextDiffTest.this.settings, (String)TextDiffTest.this.join("line1", "line2", "line3", "line4", "line5"), (String)TextDiffTest.this.join("line1", "line5"));
            Assertions.assertThat((boolean)textDiff.differencesDetected()).isTrue();
            Assertions.assertThat((String)textDiff.toString()).isEqualTo(LineSeparator.SYSTEM.convert("  1  1   line1\n  2    - line2\n  3    - line3\n  4    - line4\n  5  2   line5"));
        }

        @Test
        void testSingleLineRemoved() throws Exception {
            TextDiff textDiff = TextDiff.compare((TextDiff.Settings)TextDiffTest.this.settings, (String)"Just a single line", (String)"");
            Assertions.assertThat((boolean)textDiff.differencesDetected()).isTrue();
            Assertions.assertThat((String)textDiff.toString()).isEqualTo("  1    - Just a single line");
        }

        @Test
        void testSingleLineAdded() throws Exception {
            TextDiff textDiff = TextDiff.compare((TextDiff.Settings)TextDiffTest.this.settings, (String)"", (String)"Just a single line");
            Assertions.assertThat((boolean)textDiff.differencesDetected()).isTrue();
            Assertions.assertThat((String)textDiff.toString()).isEqualTo("     1 + Just a single line");
        }

        @Test
        void testLinebreakChangeIgnoreWhitespaces() throws Exception {
            TextDiff textDiff = TextDiff.compare((TextDiff.Settings)TextDiffTest.this.settings, (String)"line1\nline2", (String)"line1\r\nline2");
            Assertions.assertThat((boolean)textDiff.differencesDetected()).isFalse();
            Assertions.assertThat((String)textDiff.toString()).isEqualTo("");
        }
    }
}

