/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.impl;

import de.skuzzle.test.snapshots.impl.OrphanDetectionResult;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class OrphanPostProcessor {
    OrphanPostProcessor() {
    }

    public Stream<OrphanDetectionResult> orphanedOnly(Collection<OrphanDetectionResult> results) {
        Map<Path, List<OrphanDetectionResult>> resultsByFile = results.stream().collect(Collectors.groupingBy(OrphanDetectionResult::snapshotFile));
        return resultsByFile.values().stream().map(this::decideIsOrphan).flatMap(Optional::stream);
    }

    private Optional<OrphanDetectionResult> decideIsOrphan(Collection<OrphanDetectionResult> resultsForOneFile) {
        OrphanDetectionResult orphan = null;
        for (OrphanDetectionResult result : resultsForOneFile) {
            if (result.status() == OrphanDetectionResult.OrphanStatus.ACTIVE) {
                return Optional.empty();
            }
            if (result.status() != OrphanDetectionResult.OrphanStatus.ORPHAN) continue;
            orphan = result;
        }
        return Optional.ofNullable(orphan);
    }
}

