/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.impl;

import de.skuzzle.test.snapshots.SnapshotFile;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Method;
import java.nio.file.Path;

final class InternalSnapshotNaming {
    InternalSnapshotNaming() {
    }

    public static String getSnapshotFileName(String snapshotName) {
        return snapshotName + ".snapshot";
    }

    public static boolean isSnapshotFile(Path path) {
        return path.getFileName().toString().endsWith(".snapshot");
    }

    public static boolean isSnapshotFileForMethod(Path path, Method testMethod) {
        try {
            return SnapshotFile.fromSnapshotFile(path).header().get("test-method").equals(testMethod.getName());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error determining snapshot header for method " + testMethod + " from snapshot file at " + path, e);
        }
    }
}

