/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.impl;

import de.skuzzle.test.snapshots.DeleteOrphanedSnapshots;
import de.skuzzle.test.snapshots.EnableSnapshotTests;
import de.skuzzle.test.snapshots.ForceUpdateSnapshots;
import de.skuzzle.test.snapshots.impl.SnapshotConfiguration;
import de.skuzzle.test.snapshots.io.DirectoryResolver;
import de.skuzzle.test.snapshots.validation.Arguments;
import java.lang.reflect.Method;
import java.nio.file.Path;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL, since="1.1.0")
final class DefaultSnapshotConfiguration
implements SnapshotConfiguration {
    private static final String FORCE_UPDATE_SYSTEM_PROPERTY = "forceUpdateSnapshots";
    private static final String DELETE_ORPHANS_SYSTEM_PROPERTY = "deleteOrphanedSnapshots";
    private final Class<?> testClass;

    private DefaultSnapshotConfiguration(Class<?> testClass) {
        this.testClass = (Class)Arguments.requireNonNull(testClass, (String)"testClass must not be null");
    }

    public static SnapshotConfiguration forTestClass(Class<?> testClass) {
        return new DefaultSnapshotConfiguration(testClass);
    }

    @Override
    public Path determineSnapshotDirectory() {
        Class<?> testClass = this.testClass();
        String testDirName = this.snapshotDirectoryName(testClass);
        Path testDirectory = DirectoryResolver.resolve((String)testDirName);
        return testDirectory;
    }

    private String snapshotDirectoryName(Class<?> testClass) {
        EnableSnapshotTests snapshotAssertions = testClass.getAnnotation(EnableSnapshotTests.class);
        String testDirName = snapshotAssertions.snapshotDirectory().isEmpty() ? this.testClass().getName().replace('.', '/') + "_snapshots" : snapshotAssertions.snapshotDirectory();
        return testDirName;
    }

    @Override
    public Class<?> testClass() {
        return this.testClass;
    }

    @Override
    public boolean isDeleteOrphanedSnapshots() {
        return this.testClass().isAnnotationPresent(DeleteOrphanedSnapshots.class) || System.getProperties().keySet().stream().map(Object::toString).anyMatch(DELETE_ORPHANS_SYSTEM_PROPERTY::equalsIgnoreCase);
    }

    @Override
    public boolean isForceUpdateSnapshotsGlobal() {
        boolean valueFromLegacyAnnotation = this.testClass().getAnnotation(EnableSnapshotTests.class).forceUpdateSnapshots();
        if (valueFromLegacyAnnotation || this.testClass().isAnnotationPresent(ForceUpdateSnapshots.class)) {
            return true;
        }
        return System.getProperties().keySet().stream().map(Object::toString).anyMatch(FORCE_UPDATE_SYSTEM_PROPERTY::equalsIgnoreCase);
    }

    @Override
    public boolean isForceUpdateSnapshotsLocal(Method testMethod) {
        if (testMethod.isAnnotationPresent(ForceUpdateSnapshots.class)) {
            return true;
        }
        return this.isForceUpdateSnapshotsGlobal();
    }

    @Override
    public boolean isSoftAssertions() {
        return this.testClass().getAnnotation(EnableSnapshotTests.class).softAssertions();
    }
}

