/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.data.text;

import de.skuzzle.test.snapshots.data.text.DiffInterpreter;
import de.skuzzle.test.snapshots.data.text.LineSeparator;
import de.skuzzle.test.snapshots.data.text.diff_match_patch;
import de.skuzzle.test.snapshots.validation.Arguments;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL, since="1.4.0")
public final class TextDiff {
    private final DiffInterpreter diffInterpreter;
    private final List<diff_match_patch.Diff> diffs;
    private final LineSeparator expectedLineSeparator;
    private final LineSeparator actualLineSeparator;

    private TextDiff(DiffInterpreter diffInterpreter, List<diff_match_patch.Diff> diffs, LineSeparator expectedLineSeparator, LineSeparator actualLineSeparator) {
        this.diffInterpreter = diffInterpreter;
        this.diffs = diffs;
        this.expectedLineSeparator = expectedLineSeparator;
        this.actualLineSeparator = actualLineSeparator;
    }

    public static TextDiff diffOf(String expected, String actual, int contextLines) {
        return TextDiff.diffOf(new DiffInterpreter().withIgnoreWhitespaceChanges(false).withContextLines(contextLines), expected, actual);
    }

    static TextDiff diffOf(DiffInterpreter diffInterpreter, String expected, String actual) {
        Arguments.requireNonNull((Object)expected, (String)"expected String must not be null");
        Arguments.requireNonNull((Object)actual, (String)"actual String must not be null");
        LineSeparator expectedLineSeparator = LineSeparator.determineFrom(expected);
        LineSeparator actualLineSeparator = LineSeparator.determineFrom(actual);
        diff_match_patch diff_match_patch2 = new diff_match_patch();
        LinkedList<diff_match_patch.Diff> diffs = diff_match_patch2.diff_main(TextDiff.sanitizeLineSeparators(expected), TextDiff.sanitizeLineSeparators(actual));
        diff_match_patch2.diff_cleanupSemanticLossless(diffs);
        return new TextDiff(diffInterpreter, diffs, expectedLineSeparator, actualLineSeparator);
    }

    private static String sanitizeLineSeparators(String s) {
        return LineSeparator.SYSTEM.convert(s);
    }

    public boolean hasDifference() {
        return this.diffInterpreter.hasFailures(this.diffs) || this.diffInterpreter.hasLineSeparatorDifference(this.expectedLineSeparator, this.actualLineSeparator);
    }

    public String toString() {
        if (this.diffs.isEmpty()) {
            return "";
        }
        StringBuilder message = new StringBuilder();
        if (this.diffInterpreter.hasLineSeparatorDifference(this.expectedLineSeparator, this.actualLineSeparator)) {
            message.append(String.format("Strings differ in linebreaks. Expected: '%s', Actual encountered: '%s'", this.expectedLineSeparator.displayName(), this.actualLineSeparator.displayName()));
            if (this.diffs.size() == 1 && this.diffs.get((int)0).operation == diff_match_patch.Operation.EQUAL) {
                return message.toString();
            }
            message.append((Object)LineSeparator.SYSTEM).append((Object)LineSeparator.SYSTEM);
        }
        ListIterator<diff_match_patch.Diff> cursor = this.diffs.listIterator();
        while (cursor.hasNext()) {
            boolean hasPrevious = cursor.hasPrevious();
            diff_match_patch.Diff current = cursor.next();
            if (current.operation == diff_match_patch.Operation.EQUAL && !hasPrevious) {
                message.append(this.diffInterpreter.renderEqualsDiff(current.text, DiffInterpreter.EqualDiffPosition.START));
                continue;
            }
            if (current.operation == diff_match_patch.Operation.EQUAL) {
                if (cursor.hasNext()) {
                    message.append(this.diffInterpreter.renderEqualsDiff(current.text, DiffInterpreter.EqualDiffPosition.MIDDLE));
                    continue;
                }
                message.append(this.diffInterpreter.renderEqualsDiff(current.text, DiffInterpreter.EqualDiffPosition.END));
                continue;
            }
            message.append(this.diffInterpreter.renderFailureDiff(current));
        }
        return message.toString();
    }
}

