/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.data.text;

import de.skuzzle.test.snapshots.data.text.LineSeparator;
import de.skuzzle.test.snapshots.data.text.diff_match_patch;
import de.skuzzle.test.snapshots.validation.Arguments;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Pattern;

final class DiffInterpreter {
    private static final Pattern WHITESPACE_ONLY = Pattern.compile("\\h+");
    private boolean ignoreWhitespaceChanges = true;
    private int contextLines = Integer.MAX_VALUE;

    DiffInterpreter() {
    }

    public DiffInterpreter withContextLines(int contextLines) {
        Arguments.check((contextLines >= 0 ? 1 : 0) != 0, (String)"contextLines must be > 0 but was %d", (Object[])new Object[]{contextLines});
        this.contextLines = contextLines;
        return this;
    }

    public DiffInterpreter withIgnoreWhitespaceChanges(boolean ignoreWhitespaceChanges) {
        this.ignoreWhitespaceChanges = ignoreWhitespaceChanges;
        return this;
    }

    private boolean isWhitespace(diff_match_patch.Diff diff) {
        return WHITESPACE_ONLY.matcher(diff.text).matches();
    }

    public boolean hasFailures(Collection<diff_match_patch.Diff> diffs) {
        return diffs.stream().anyMatch(this::isFailureDifference);
    }

    private boolean isFailureDifference(diff_match_patch.Diff diff) {
        if (diff.operation == diff_match_patch.Operation.EQUAL) {
            return false;
        }
        if (this.isWhitespace(diff)) {
            return !this.ignoreWhitespaceChanges;
        }
        return true;
    }

    boolean hasLineSeparatorDifference(LineSeparator l1, LineSeparator l2) {
        if (this.ignoreWhitespaceChanges) {
            return false;
        }
        return l1 != l2;
    }

    public String renderFailureDiff(diff_match_patch.Diff diff) {
        if (this.isFailureDifference(diff)) {
            switch (diff.operation) {
                case DELETE: {
                    return "-" + this.einklammern(diff.text);
                }
                case INSERT: {
                    return "+" + this.einklammern(diff.text);
                }
            }
            throw new IllegalStateException();
        }
        return diff.text;
    }

    private String einklammern(String text) {
        String lineSeparator = LineSeparator.SYSTEM.toString();
        if (text.endsWith(lineSeparator)) {
            return "[" + text.substring(0, text.length() - lineSeparator.length()) + "]" + lineSeparator;
        }
        return "[" + text + "]";
    }

    public String renderEqualsDiff(String diffText, EqualDiffPosition position) {
        return position.render(diffText, this.contextLines);
    }

    static enum EqualDiffPosition {
        START{

            @Override
            protected String render(String diffText, int contextLines) {
                int totalLines = (int)diffText.lines().count();
                StringBuilder b = new StringBuilder();
                boolean appendOnce = true;
                Iterator lineIterator = diffText.lines().iterator();
                for (int lineNr = 0; lineNr < totalLines; ++lineNr) {
                    String nextLine = (String)lineIterator.next();
                    if (lineNr >= totalLines - contextLines) {
                        b.append(nextLine);
                        if (lineNr >= totalLines - 1 && !LineSeparator.SYSTEM.endsWith(diffText)) continue;
                        b.append((Object)LineSeparator.SYSTEM);
                        continue;
                    }
                    if (!appendOnce) continue;
                    b.append("[...]").append((Object)LineSeparator.SYSTEM);
                    appendOnce = false;
                }
                return b.toString();
            }
        }
        ,
        MIDDLE{

            @Override
            protected String render(String diffText, int contextLines) {
                int totalLines = (int)diffText.lines().count();
                StringBuilder b = new StringBuilder();
                boolean appendOnce = true;
                Iterator lineIterator = diffText.lines().iterator();
                for (int lineNr = 0; lineNr < totalLines; ++lineNr) {
                    String nextLine = (String)lineIterator.next();
                    if (lineNr < contextLines || lineNr >= totalLines - contextLines) {
                        b.append(nextLine);
                        if (lineNr >= totalLines - 1) continue;
                        b.append((Object)LineSeparator.SYSTEM);
                        continue;
                    }
                    if (!appendOnce) continue;
                    b.append("[...]").append((Object)LineSeparator.SYSTEM);
                    appendOnce = false;
                }
                return b.toString();
            }
        }
        ,
        END{

            @Override
            protected String render(String diffText, int contextLines) {
                int totalLines = (int)diffText.lines().count();
                StringBuilder b = new StringBuilder();
                boolean appendOnce = true;
                Iterator lineIterator = diffText.lines().iterator();
                for (int lineNr = 0; lineNr < totalLines; ++lineNr) {
                    String nextLine = (String)lineIterator.next();
                    if (lineNr < contextLines) {
                        b.append(nextLine);
                        if (lineNr >= totalLines - 1) continue;
                        b.append((Object)LineSeparator.SYSTEM);
                        continue;
                    }
                    if (!appendOnce) continue;
                    b.append("[...]");
                    appendOnce = false;
                }
                return b.toString();
            }
        };


        protected abstract String render(String var1, int var2);
    }
}

