/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.impl;

import de.skuzzle.test.snapshots.EnableSnapshotTests;
import de.skuzzle.test.snapshots.SnapshotDsl;
import de.skuzzle.test.snapshots.SnapshotFile;
import de.skuzzle.test.snapshots.impl.DefaultSnapshotConfiguration;
import de.skuzzle.test.snapshots.impl.MetaTest;
import de.skuzzle.test.snapshots.impl.MockOrphanCollector;
import de.skuzzle.test.snapshots.impl.OrphanDetectionResult;
import de.skuzzle.test.snapshots.io.DirectoryResolver;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.DisplayNameGeneration;
import org.junit.jupiter.api.DisplayNameGenerator;
import org.junit.jupiter.api.Test;

@DisplayNameGeneration(value=DisplayNameGenerator.ReplaceUnderscores.class)
public class OrphanedSnapshotDetectionTest {
    private final MetaTest frameworkTest = new MetaTest();
    private final MockOrphanCollector orphans = MockOrphanCollector.installNewInstance();

    @AfterEach
    void uninstallMockCollector() {
        MockOrphanCollector.uninstall();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void orphaned_file_for_changed_snapshot_directory_should_correctly_be_detected() throws IOException {
        Path localTemp = DirectoryResolver.resolve((String)"localtemp");
        String fileName = "someSnapshotTest_0.snapshot";
        Path snapshotFile = localTemp.resolve("someSnapshotTest_0.snapshot");
        try {
            Files.createDirectories(localTemp, new FileAttribute[0]);
            this.createArtificialSnapshotFile(TestCase.class, "someSnapshotTest", "someSnapshotTest", "content", false).writeTo(snapshotFile);
            this.frameworkTest.executeTestcasesIn(TestCase.class);
            this.orphans.results().areAtLeast(1, this.forFileWithName("someSnapshotTest_0.snapshot"));
        }
        finally {
            Files.delete(snapshotFile);
            Files.delete(localTemp);
        }
    }

    @Test
    void orphaned_file_for_deleted_test_should_correctly_be_detected() throws Throwable {
        this.frameworkTest.executeTestcasesIn(TestCase.class);
        this.orphans.results().areExactly(1, this.forFileWithName("testThatHasBeenDeleted_0.snapshot"));
    }

    @Test
    void snapshot_for_test_that_is_disabled_should_not_be_detected_as_orphan() throws Throwable {
        this.frameworkTest.executeTestcasesIn(TestCase.class);
        this.orphans.results().areNot(this.forFileWithName("disabledTest_0.snapshot"));
    }

    @Test
    void disabled_assertion_should_not_be_detected_as_orphan() throws IOException {
        this.frameworkTest.executeTestcasesIn(TestCase.class);
        this.orphans.results().areNot(this.forFileWithName("testWithDisabledAssertion_0.snapshot"));
    }

    @Test
    void snapshot_for_existing_test_in_different_class_that_was_not_executed_should_not_be_detected_as_orphan() throws Throwable {
        this.frameworkTest.executeTestcasesIn(AnotherTestClass.class);
        this.orphans.results().areNot(this.forFileWithName("disabledTest_0.snapshot"));
    }

    @Test
    void orphaned_files_should_not_be_detected_for_failing_tests() throws Throwable {
        this.frameworkTest.executeTestcasesIn(TestCase.class);
        this.orphans.results().areNot(this.forFileWithName("failingTestMethod.snapshot"));
    }

    @Test
    void orphaned_file_for_disabled_assertion_within_testshould_correctly_be_detected() throws Throwable {
        this.frameworkTest.executeTestcasesIn(TestCase.class);
        this.orphans.results().areExactly(1, this.forFileWithName("testWithChangedAssertions_1.snapshot"));
    }

    @Test
    void header_should_be_changed_if_test_method_has_been_renamed() throws Throwable {
        Path snapshotFile = this.storeArtificialSnapshotFile(TestCaseThatChangesHeader.class, "old_method_name", "custom_snapshot_name", "content", false);
        try {
            this.frameworkTest.executeTestcasesIn(TestCaseThatChangesHeader.class);
            SnapshotFile.SnapshotHeader updatedHeader = SnapshotFile.fromSnapshotFile((Path)snapshotFile).header();
            Assertions.assertThat((String)updatedHeader.get("test-method")).isEqualTo("new_method_name");
        }
        finally {
            Files.delete(snapshotFile);
        }
    }

    private Path determineDefaultSnapshotDirectory(Class<?> testClass) throws IOException {
        Path snapshotDirectory = DefaultSnapshotConfiguration.forTestClass(testClass).determineSnapshotDirectory();
        Files.createDirectories(snapshotDirectory, new FileAttribute[0]);
        return snapshotDirectory;
    }

    private SnapshotFile createArtificialSnapshotFile(Class<?> testClass, String testMethodName, String snapshotName, String snapshot, boolean dynamicDirectory) throws IOException {
        SnapshotFile.SnapshotHeader header = SnapshotFile.SnapshotHeader.fromMap(Map.of("snapshot-number", "0", "test-method", testMethodName, "test-class", testClass.getName(), "snapshot-name", snapshotName, "dynamic-directory", "" + dynamicDirectory));
        return SnapshotFile.of((SnapshotFile.SnapshotHeader)header, (String)snapshot);
    }

    private Path storeArtificialSnapshotFile(Class<?> testClass, String testMethodName, String snapshotName, String snapshot, boolean dynamicDirectory) throws IOException {
        Path snapshotFilePath = this.determineDefaultSnapshotDirectory(testClass).resolve(snapshotName + ".snapshot");
        this.createArtificialSnapshotFile(testClass, testMethodName, snapshotName, snapshot, dynamicDirectory).writeTo(snapshotFilePath);
        return snapshotFilePath;
    }

    private Condition<OrphanDetectionResult> forFileWithName(String fileName) {
        return new Condition(result -> result.snapshotFile().getFileName().toString().equals(fileName), "with filename '%s'", new Object[]{fileName});
    }

    @EnableSnapshotTests
    static class TestCaseThatChangesHeader {
        TestCaseThatChangesHeader() {
        }

        @Test
        void new_method_name(SnapshotDsl.Snapshot snapshot) {
            MetaTest.assumeMetaTest();
            snapshot.named("custom_snapshot_name").assertThat((Object)"content").asText().matchesSnapshotText();
        }
    }

    @EnableSnapshotTests
    static class AnotherTestClass {
        AnotherTestClass() {
        }

        @Test
        void anotherWorkingTest(SnapshotDsl.Snapshot snapshot) {
            MetaTest.assumeMetaTest();
            snapshot.assertThat((Object)"1").asText().matchesSnapshotText();
        }
    }

    @EnableSnapshotTests
    static class TestCase {
        TestCase() {
        }

        @Test
        void testWithChangedAssertions(SnapshotDsl.Snapshot snapshot) {
            MetaTest.assumeMetaTest();
            snapshot.assertThat((Object)"1").asText().matchesSnapshotText();
        }

        @Test
        void someSnapshotTest(SnapshotDsl.Snapshot snapshot) {
            MetaTest.assumeMetaTest();
        }

        @Test
        @Disabled
        void disabledTest(SnapshotDsl.Snapshot snapshot) {
            MetaTest.assumeMetaTest();
            snapshot.assertThat((Object)"1").asText().matchesSnapshotText();
        }

        @Test
        void testWithDisabledAssertion(SnapshotDsl.Snapshot snapshot) throws Exception {
            MetaTest.assumeMetaTest();
            snapshot.assertThat((Object)"1").asText().matchesSnapshotText();
        }

        @Test
        void failingTestMethod(SnapshotDsl.Snapshot snapshot) {
            MetaTest.assumeMetaTest();
            throw new RuntimeException();
        }
    }
}

