/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.impl;

import de.skuzzle.test.snapshots.impl.OrphanCollectorHolder;
import de.skuzzle.test.snapshots.impl.OrphanDetectionResult;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;

final class MockOrphanCollector
implements OrphanCollectorHolder.OrphanCollector {
    private final List<OrphanDetectionResult> rawResults = new ArrayList<OrphanDetectionResult>();
    private final List<OrphanDetectionResult> postProcessedResults = new ArrayList<OrphanDetectionResult>();

    public static MockOrphanCollector installNewInstance() {
        MockOrphanCollector collector = new MockOrphanCollector();
        OrphanCollectorHolder.setCollector((OrphanCollectorHolder.OrphanCollector)collector);
        return collector;
    }

    public static MockOrphanCollector uninstall() {
        MockOrphanCollector result = (MockOrphanCollector)OrphanCollectorHolder.getCollector();
        OrphanCollectorHolder.reset();
        return result;
    }

    private MockOrphanCollector() {
    }

    public ListAssert<OrphanDetectionResult> rawResults() {
        return Assertions.assertThat(this.rawResults);
    }

    public ListAssert<OrphanDetectionResult> results() {
        return Assertions.assertThat(this.postProcessedResults);
    }

    public void addRawResult(OrphanDetectionResult result) {
        this.rawResults.add(result);
    }

    public void addPostProcessedResult(OrphanDetectionResult result) {
        this.postProcessedResults.add(result);
    }
}

