/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.data.text;

import de.skuzzle.test.snapshots.data.text.DiffInterpreter;
import de.skuzzle.test.snapshots.data.text.LineSeparator;
import de.skuzzle.test.snapshots.data.text.TextDiff;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TextDiffTest {
    @Test
    void testHasDifferenceFalseIfIgnoreWhitespacesAndOnlyWhitespaceChanges() throws Exception {
        TextDiff diffOf = TextDiff.diffOf((DiffInterpreter)new DiffInterpreter().withIgnoreWhitespaceChanges(true), (String)"    ", (String)"  ");
        Assertions.assertThat((boolean)diffOf.hasDifference()).isFalse();
    }

    @Test
    void testHasDifferenceFalseIfIgnoreWhitespacesAndOnlyLineSeparatorChanges() throws Exception {
        TextDiff diffOf = TextDiff.diffOf((DiffInterpreter)new DiffInterpreter().withIgnoreWhitespaceChanges(true), (String)"a\rb", (String)"a\nb");
        Assertions.assertThat((boolean)diffOf.hasDifference()).isFalse();
    }

    @Test
    void testDiffOfEmptyStrings() throws Exception {
        TextDiff diff = TextDiff.diffOf((DiffInterpreter)new DiffInterpreter(), (String)"", (String)"");
        Assertions.assertThat((String)diff.toString()).isEmpty();
        Assertions.assertThat((boolean)diff.hasDifference()).isFalse();
    }

    @Test
    void testDiffWithLinebreaksAndLessThanContextLinesWithTrailingLineBreak() throws Exception {
        TextDiff diff = TextDiff.diffOf((DiffInterpreter)new DiffInterpreter().withIgnoreWhitespaceChanges(false).withContextLines(50), (String)"1\n2\n3\n4\n5\n6\n7\nline1\n", (String)"1\n2\n3\n4\n5\n6\n7\nlineX\n");
        Assertions.assertThat((String)diff.toString()).isEqualTo(LineSeparator.SYSTEM.convert("1\n2\n3\n4\n5\n6\n7\nline-[1]+[X]\n"));
        Assertions.assertThat((boolean)diff.hasDifference()).isTrue();
    }

    @Test
    void testDiffWithLinebreaksAndLessThanContextLinesWithoutTrailingLineBreak() throws Exception {
        TextDiff diff = TextDiff.diffOf((DiffInterpreter)new DiffInterpreter().withIgnoreWhitespaceChanges(false).withContextLines(50), (String)"1\n2\n3\n4\n5\n6\n7\nline1", (String)"1\n2\n3\n4\n5\n6\n7\nlineX");
        Assertions.assertThat((String)diff.toString()).isEqualTo(LineSeparator.SYSTEM.convert("1\n2\n3\n4\n5\n6\n7\nline-[1]+[X]"));
        Assertions.assertThat((boolean)diff.hasDifference()).isTrue();
    }

    @Test
    void testDiffOnlyInLinebreaks() throws Exception {
        TextDiff diff = TextDiff.diffOf((DiffInterpreter)new DiffInterpreter().withContextLines(5).withIgnoreWhitespaceChanges(false), (String)"line1\n1\n2\n3\n4\n5\n6\n7", (String)"line1\r1\r2\r3\r4\r5\r6\r7");
        Assertions.assertThat((String)diff.toString()).isEqualTo("Strings differ in linebreaks. Expected: 'LF(\\n)', Actual encountered: 'CR(\\r)'");
    }

    @Test
    void testDiffInLinebreaks() throws Exception {
        TextDiff diff = TextDiff.diffOf((DiffInterpreter)new DiffInterpreter().withContextLines(5).withIgnoreWhitespaceChanges(false), (String)"line1\n1\n2\n3\n4\n5\n6\n7", (String)"lineX\r1\r2\r3\r4\r5\r6\r7");
        Assertions.assertThat((String)diff.toString()).isEqualTo(LineSeparator.SYSTEM.convert("Strings differ in linebreaks. Expected: 'LF(\\n)', Actual encountered: 'CR(\\r)'\n\nline-[1]+[X]\r1\r2\r3\r4\r[...]"));
        Assertions.assertThat((boolean)diff.hasDifference()).isTrue();
    }

    @Test
    void testDiffWithHugeEqualBlockAtTheStart() throws Exception {
        TextDiff diff = TextDiff.diffOf((DiffInterpreter)new DiffInterpreter().withContextLines(5), (String)"1\n2\n3\n4\n5\n6\n7\nline1", (String)"1\n2\n3\n4\n5\n6\n7\nlineX");
        Assertions.assertThat((String)diff.toString()).isEqualTo(LineSeparator.SYSTEM.convert("[...]\n4\n5\n6\n7\nline-[1]+[X]"));
        Assertions.assertThat((boolean)diff.hasDifference()).isTrue();
    }

    @Test
    void testDiffWithHugeEqualBlockAtTheEnd() throws Exception {
        TextDiff diff = TextDiff.diffOf((DiffInterpreter)new DiffInterpreter().withContextLines(5), (String)"line1\n1\n2\n3\n4\n5\n6\n7", (String)"lineX\n1\n2\n3\n4\n5\n6\n7");
        Assertions.assertThat((String)diff.toString()).isEqualTo(LineSeparator.SYSTEM.convert("line-[1]+[X]\n1\n2\n3\n4\n[...]"));
        Assertions.assertThat((boolean)diff.hasDifference()).isTrue();
    }

    @Test
    void testDiffWithHugeEqualBlockAtTheStartAndTheEnd() throws Exception {
        TextDiff diff = TextDiff.diffOf((DiffInterpreter)new DiffInterpreter().withContextLines(5), (String)"1\n2\n3\n4\n5\n6\n7\nline1\n8\n9\n10\n11\n12\n13\n14", (String)"1\n2\n3\n4\n5\n6\n7\n8\n9\n10\n11\n12\n13\n14");
        Assertions.assertThat((String)diff.toString()).isEqualTo(LineSeparator.SYSTEM.convert("[...]\n3\n4\n5\n6\n7\n-[line1]\n8\n9\n10\n11\n12\n[...]"));
        Assertions.assertThat((boolean)diff.hasDifference()).isTrue();
    }

    @Test
    void testDiffWithHugeEqualBlockInTheMiddle() throws Exception {
        TextDiff diff = TextDiff.diffOf((DiffInterpreter)new DiffInterpreter().withContextLines(5), (String)"line1\n1\n2\n3\n4\n5\n6\n7\nline2\n8\n9\n10\n11\n12\n13\n14\nline3", (String)"line2\n1\n2\n3\n4\n5\n6\n7\nline2\n8\n9\n10\n11\n12\n13\n14\nline4");
        Assertions.assertThat((String)diff.toString()).isEqualTo(LineSeparator.SYSTEM.convert("line-[1]+[2]\n1\n2\n3\n4\n[...]\n11\n12\n13\n14\nline-[3]+[4]"));
        Assertions.assertThat((boolean)diff.hasDifference()).isTrue();
    }
}

