/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.impl;

import java.util.Arrays;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class Throwables {
    private Throwables() {
    }

    public static void throwIfNotNull(Throwable throwable) throws Exception {
        if (throwable == null) {
            return;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof Exception) {
            throw (Exception)throwable;
        }
        throw new RuntimeException(throwable);
    }

    public static Throwable flattenThrowables(Stream<? extends Throwable> results) {
        return results.collect(Collectors.reducing(Throwables::combine)).orElse(null);
    }

    public static Throwable combine(Throwable t, Throwable other) {
        if (t == null) {
            return other;
        }
        if (other != null) {
            t.addSuppressed(other);
        }
        return t;
    }

    public static void filterStackTrace(Throwable throwable, Predicate<StackTraceElement> elementsToRemove) {
        StackTraceElement[] original = throwable.getStackTrace();
        StackTraceElement[] filtered = (StackTraceElement[])Arrays.stream(original).filter(elementsToRemove.negate()).toArray(StackTraceElement[]::new);
        throwable.setStackTrace(filtered);
    }
}

