/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.impl;

import de.skuzzle.test.snapshots.SnapshotDsl;
import de.skuzzle.test.snapshots.SnapshotException;
import de.skuzzle.test.snapshots.SnapshotFile;
import de.skuzzle.test.snapshots.SnapshotNaming;
import de.skuzzle.test.snapshots.SnapshotSerializer;
import de.skuzzle.test.snapshots.SnapshotTestResult;
import de.skuzzle.test.snapshots.StructuralAssertions;
import de.skuzzle.test.snapshots.data.text.TextDiff;
import de.skuzzle.test.snapshots.data.text.TextDiffAssertionError;
import de.skuzzle.test.snapshots.impl.DslState;
import de.skuzzle.test.snapshots.impl.InternalSnapshotNaming;
import de.skuzzle.test.snapshots.impl.LocalResultCollector;
import de.skuzzle.test.snapshots.impl.SnapshotConfiguration;
import de.skuzzle.test.snapshots.impl.SnapshotDslImpl;
import de.skuzzle.test.snapshots.impl.SnapshotTestContext;
import de.skuzzle.test.snapshots.impl.Throwables;
import de.skuzzle.test.snapshots.validation.Arguments;
import de.skuzzle.test.snapshots.validation.State;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Optional;
import org.opentest4j.AssertionFailedError;

final class SnapshotTestImpl
implements SnapshotDsl.Snapshot {
    private static final String UNAVAILABLE_BECAUSE_ACTUAL_WAS_NULL = "<<unavailable because actual was null>>";
    private static final int DEFAULT_CONTEXT_LINES = 5;
    private final Method testMethod;
    private final SnapshotTestContext context;
    private final SnapshotConfiguration configuration;
    private final LocalResultCollector localResultCollector = new LocalResultCollector();
    private SnapshotNaming namingStrategy = SnapshotNaming.defaultNaming();
    private Path directoryOverride;
    private final DslState state = DslState.initial();

    SnapshotTestImpl(SnapshotTestContext context, SnapshotConfiguration configuration, Method testMethod) {
        this.configuration = (SnapshotConfiguration)Arguments.requireNonNull((Object)configuration, (String)"configuration must not be null");
        this.testMethod = (Method)Arguments.requireNonNull((Object)testMethod, (String)"testMethod must not be null");
        this.context = context;
    }

    @Override
    public SnapshotDsl.ChooseActual namedAccordingTo(SnapshotNaming namingStrategy) {
        this.state.append(2);
        this.namingStrategy = (SnapshotNaming)Arguments.requireNonNull((Object)namingStrategy, (String)"namingStrategy must not be null");
        return this;
    }

    @Override
    public SnapshotDsl.ChooseName in(Path directory) {
        this.state.append(8);
        this.directoryOverride = (Path)Arguments.requireNonNull((Object)directory, (String)"snapshot directory must not be null");
        return this;
    }

    @Override
    public SnapshotDsl.ChooseDataFormat assertThat(Object actual) {
        this.state.append(4);
        return new SnapshotDslImpl(this, actual);
    }

    private SnapshotFile.SnapshotHeader determineNextSnapshotHeader(String snapshotName) {
        return SnapshotFile.SnapshotHeader.fromMap(Map.of("snapshot-number", "" + this.localResultCollector.size(), "test-method", this.testMethod.getName(), "test-class", this.configuration.testClass().getName(), "snapshot-name", snapshotName, "dynamic-directory", "" + (this.directoryOverride != null)));
    }

    private Path determineSnapshotFile(String snapshotName) throws IOException {
        String snapshotFileName = InternalSnapshotNaming.getSnapshotFileName(snapshotName);
        return this.determineSnapshotDirectory().resolve(snapshotFileName);
    }

    private Path determineSnapshotDirectory() throws IOException {
        Path snapshotDirectory = this.directoryOverride != null ? this.directoryOverride : this.configuration.determineSnapshotDirectory();
        Files.createDirectories(snapshotDirectory, new FileAttribute[0]);
        return snapshotDirectory;
    }

    SnapshotTestResult justUpdateSnapshotWith(SnapshotSerializer snapshotSerializer, Object actual) throws Exception {
        this.state.reset();
        if (actual == null) {
            throw new AssertionError((Object)"Expected actual not to be null in order to take initial snapshot");
        }
        String snapshotName = this.namingStrategy.determineSnapshotName(this.testMethod, this.localResultCollector.size());
        Path snapshotFilePath = this.determineSnapshotFile(snapshotName);
        String serializedActual = snapshotSerializer.serialize(actual);
        SnapshotFile.SnapshotHeader snapshotHeader = this.determineNextSnapshotHeader(snapshotName);
        SnapshotFile snapshotFile = SnapshotFile.of(snapshotHeader, serializedActual).writeTo(snapshotFilePath);
        SnapshotTestResult result = SnapshotTestResult.of(snapshotFilePath, SnapshotTestResult.SnapshotStatus.UPDATED_FORCEFULLY, snapshotFile);
        this.recordSnapshotTestResult(result);
        return result;
    }

    private void recordSnapshotTestResult(SnapshotTestResult result) {
        this.localResultCollector.recordSnapshotTestResult(result);
        this.context.recordSnapshotTestResult(result);
    }

    SnapshotTestResult disabled(SnapshotSerializer snapshotSerializer, StructuralAssertions structuralAssertions, Object actual) throws Exception {
        this.state.reset();
        String snapshotName = this.namingStrategy.determineSnapshotName(this.testMethod, this.localResultCollector.size());
        Path snapshotFilePath = this.determineSnapshotFile(snapshotName);
        SnapshotFile.SnapshotHeader snapshotHeader = this.determineNextSnapshotHeader(snapshotName);
        String serializedActual = actual == null ? UNAVAILABLE_BECAUSE_ACTUAL_WAS_NULL : snapshotSerializer.serialize(actual);
        SnapshotFile snapshotFile = SnapshotFile.of(snapshotHeader, serializedActual);
        SnapshotTestResult result = SnapshotTestResult.of(snapshotFilePath, SnapshotTestResult.SnapshotStatus.DISABLED, snapshotFile);
        this.recordSnapshotTestResult(result);
        return result;
    }

    SnapshotTestResult executeAssertionWith(SnapshotSerializer snapshotSerializer, StructuralAssertions structuralAssertions, Object actual) throws Exception {
        SnapshotTestResult result;
        this.state.reset();
        String snapshotName = this.namingStrategy.determineSnapshotName(this.testMethod, this.localResultCollector.size());
        Path snapshotFilePath = this.determineSnapshotFile(snapshotName);
        boolean forceUpdateSnapshots = this.configuration.isForceUpdateSnapshotsLocal(this.testMethod);
        boolean snapshotFileAlreadyExists = Files.exists(snapshotFilePath, new LinkOption[0]);
        SnapshotFile.SnapshotHeader snapshotHeader = this.determineNextSnapshotHeader(snapshotName);
        if (forceUpdateSnapshots || !snapshotFileAlreadyExists) {
            if (actual == null) {
                throw new AssertionError((Object)"Expected actual not to be null in order to take initial snapshot");
            }
            String serializedActual = snapshotSerializer.serialize(actual);
            SnapshotFile snapshotFile = SnapshotFile.of(snapshotHeader, serializedActual).writeTo(snapshotFilePath);
            SnapshotTestResult.SnapshotStatus status = snapshotFileAlreadyExists ? SnapshotTestResult.SnapshotStatus.UPDATED_FORCEFULLY : SnapshotTestResult.SnapshotStatus.CREATED_INITIALLY;
            result = SnapshotTestResult.of(snapshotFilePath, status, snapshotFile);
        } else {
            SnapshotFile snapshotFile = this.readSnapshotFileAndUpdateHeader(snapshotFilePath, snapshotHeader);
            String storedSnapshot = snapshotFile.snapshot();
            if (actual == null) {
                throw new AssertionError((Object)("Expected actual not to be null but to match stored snapshot:\n\n" + storedSnapshot));
            }
            String serializedActual = snapshotSerializer.serialize(actual);
            result = this.compareTestResults(structuralAssertions, storedSnapshot, serializedActual, snapshotFilePath).map(assertionError -> SnapshotTestResult.forFailedTest(snapshotFilePath, snapshotFile, assertionError)).orElseGet(() -> SnapshotTestResult.of(snapshotFilePath, SnapshotTestResult.SnapshotStatus.ASSERTED, snapshotFile));
        }
        this.recordSnapshotTestResult(result);
        if (!this.configuration.isSoftAssertions()) {
            this.localResultCollector.assertSuccessEagerly();
        }
        return result;
    }

    private SnapshotFile readSnapshotFileAndUpdateHeader(Path snapshotFilePath, SnapshotFile.SnapshotHeader newHeader) throws IOException {
        SnapshotFile snapshotFile = SnapshotFile.fromSnapshotFile(snapshotFilePath);
        if (!newHeader.equals(snapshotFile.header())) {
            snapshotFile = snapshotFile.changeHeader(newHeader).writeTo(snapshotFilePath);
        }
        return snapshotFile;
    }

    public void executeFinalAssertions() throws Exception {
        State.check((boolean)this.state.isInitial(), (String)"Detected incomplete DSL usage. Please always call a terminal operation (see JavaDoc of the Snapshot class for details). If you want to temporarily disable a snapshot assertion, use the disabled() terminal operation.", (Object[])new Object[0]);
        this.localResultCollector.assertSuccess();
    }

    private Optional<Throwable> compareTestResults(StructuralAssertions structuralAssertions, String storedSnapshot, String serializedActual, Path snapshotFile) {
        try {
            structuralAssertions.assertEquals(storedSnapshot, serializedActual);
            return Optional.empty();
        }
        catch (AssertionError e) {
            AssertionError diffableAssertionError = this.toDiffableAssertionError(e, serializedActual, storedSnapshot, snapshotFile);
            return Optional.of(diffableAssertionError);
        }
        catch (SnapshotException e) {
            return Optional.of(e);
        }
    }

    private AssertionError toDiffableAssertionError(AssertionError original, String serializedActual, String storedSnapshot, Path snapshotFile) {
        StringBuilder assertionMessage = new StringBuilder();
        if (((Throwable)((Object)original)).getMessage() != null) {
            assertionMessage.append(((Throwable)((Object)original)).getMessage());
        }
        assertionMessage.append(System.lineSeparator()).append(System.lineSeparator()).append("Snapshot location:").append(System.lineSeparator()).append("\t").append(snapshotFile.toString()).append(System.lineSeparator());
        TextDiff testDiff = this.determineDiff(original, storedSnapshot, serializedActual);
        if (testDiff.hasDifference()) {
            assertionMessage.append(System.lineSeparator()).append("Full unified diff of actual result and stored snapshot:").append(System.lineSeparator()).append(testDiff);
        }
        AssertionFailedError error = new AssertionFailedError(assertionMessage.toString(), (Object)storedSnapshot, (Object)serializedActual, ((Throwable)((Object)original)).getCause());
        String internalPackage = SnapshotTestImpl.class.getPackageName();
        Throwables.filterStackTrace((Throwable)error, element -> element.getClassName().startsWith(internalPackage));
        return error;
    }

    private TextDiff determineDiff(AssertionError original, String storedSnapshot, String serializedActual) {
        if (original instanceof TextDiffAssertionError) {
            return ((TextDiffAssertionError)original).textDiff();
        }
        return TextDiff.diffOf(storedSnapshot, serializedActual, 5);
    }
}

