/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.data.text;

import de.skuzzle.test.snapshots.StructuredData;
import de.skuzzle.test.snapshots.StructuredDataProvider;
import de.skuzzle.test.snapshots.data.text.DiffInterpreter;
import de.skuzzle.test.snapshots.data.text.TextDiffStructuralAssertions;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class TextSnapshot
implements StructuredDataProvider {
    private final DiffInterpreter diffInterpreter = new DiffInterpreter();
    public static final StructuredData text = TextSnapshot.text().withIgnoreWhitespaces(true).build();

    private TextSnapshot() {
    }

    @API(status=API.Status.STABLE, since="1.4.0")
    public static TextSnapshot text() {
        return new TextSnapshot();
    }

    @API(status=API.Status.STABLE, since="1.4.0")
    public TextSnapshot withIgnoreWhitespaces(boolean ignoreWhitespaces) {
        this.diffInterpreter.withIgnoreWhitespaceChanges(ignoreWhitespaces);
        return this;
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.5.0")
    public TextSnapshot withContextLines(int contextLines) {
        this.diffInterpreter.withContextLines(contextLines);
        return this;
    }

    @Override
    public StructuredData build() {
        TextDiffStructuralAssertions structuralAssertions = new TextDiffStructuralAssertions(this.diffInterpreter);
        return StructuredData.with(Object::toString, structuralAssertions);
    }
}

