/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots;

import de.skuzzle.test.snapshots.EnableSnapshotTests;
import de.skuzzle.test.snapshots.SnapshotDsl;
import de.skuzzle.test.snapshots.SnapshotNaming;
import de.skuzzle.test.snapshots.SnapshotTestResult;
import java.nio.file.Path;
import java.time.LocalDate;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@EnableSnapshotTests
public class SnapshotsTest {
    @Test
    void testDisabledWithNullInput(SnapshotDsl.Snapshot snapshot) throws Exception {
        SnapshotTestResult testResult = snapshot.assertThat(null).asText().disabled();
        Assertions.assertThat((String)testResult.serializedSnapshot().snapshot()).isEqualTo("<<unavailable because actual was null>>");
    }

    @Test
    void testWithOneDisabledAssertionForWhichSnapshotHasNotYetBeenCreated(SnapshotDsl.Snapshot snapshot) throws Exception {
        Person simon = this.determinePerson();
        SnapshotTestResult testResultDisabled = snapshot.assertThat((Object)simon).asText().disabled();
        Assertions.assertThat((Comparable)testResultDisabled.status()).isEqualTo((Object)SnapshotTestResult.SnapshotStatus.DISABLED);
        Assertions.assertThat((Path)testResultDisabled.targetFile()).doesNotExist();
        Person phil = this.determinePerson().setName("Phil");
        SnapshotTestResult testResultActive = snapshot.assertThat((Object)phil).asText().matchesSnapshotText();
        Assertions.assertThat((Comparable)testResultActive.status()).isEqualTo((Object)SnapshotTestResult.SnapshotStatus.ASSERTED);
    }

    @Test
    void testWithOneDisabledAssertionForWhichSnapshotHasAlreadyBeenCreated(SnapshotDsl.Snapshot snapshot) throws Exception {
        Person simon = this.determinePerson();
        SnapshotTestResult testResultDisabled = snapshot.assertThat((Object)simon).asText().disabled();
        Assertions.assertThat((Comparable)testResultDisabled.status()).isEqualTo((Object)SnapshotTestResult.SnapshotStatus.DISABLED);
        Assertions.assertThat((Path)testResultDisabled.targetFile()).exists();
        Person phil = this.determinePerson().setName("Phil");
        snapshot.assertThat((Object)phil).asText().matchesSnapshotText();
    }

    @Test
    void testMultipleSnapshotsInOneTestCase(SnapshotDsl.Snapshot snapshot) throws Throwable {
        Person simon = this.determinePerson();
        snapshot.assertThat((Object)simon).asText().matchesSnapshotText();
        Person phil = this.determinePerson().setName("Phil");
        snapshot.assertThat((Object)phil).asText().matchesSnapshotText();
    }

    @Test
    void testWithExplicitSnapshotName(SnapshotDsl.Snapshot snapshot) throws Exception {
        Person simon = this.determinePerson();
        snapshot.named("simon").assertThat((Object)simon).asText().matchesSnapshotText();
        Person phil = this.determinePerson().setName("Phil");
        snapshot.named("phil").assertThat((Object)phil).asText().matchesSnapshotText();
    }

    @ParameterizedTest
    @ValueSource(strings={"string1", "string2"})
    void testParameterized(String param, SnapshotDsl.Snapshot snapshot) {
        snapshot.namedAccordingTo(SnapshotNaming.withParameters((Object)param, (Object[])new Object[0])).assertThat((Object)param).asText().matchesSnapshotText();
    }

    private Person determinePerson() {
        return new Person().setName("Simon").setSurname("Taddiken").setBirthdate(LocalDate.of(1777, 1, 12)).setAddress(new Address().setCity("Bielefeld").setCountry("Germany").setStreet("Gibtsnicht-Stra\u00dfe").setNumber("1337").setZipCode("4711"));
    }

    public static class Person {
        private String name;
        private String surname;
        private LocalDate birthdate;
        private Address address;

        public String getName() {
            return this.name;
        }

        public Person setName(String name) {
            this.name = name;
            return this;
        }

        public String getSurname() {
            return this.surname;
        }

        public Person setSurname(String surname) {
            this.surname = surname;
            return this;
        }

        public LocalDate getBirthdate() {
            return this.birthdate;
        }

        public Person setBirthdate(LocalDate birthdate) {
            this.birthdate = birthdate;
            return this;
        }

        public Address getAddress() {
            return this.address;
        }

        public Person setAddress(Address address) {
            this.address = address;
            return this;
        }

        public String toString() {
            return "Name: " + this.name + "\n" + "Surname: " + this.surname + "\n" + "Birthdate: " + this.birthdate + "\n" + "Address: " + this.address + "\n";
        }
    }

    public static class Address {
        private String street;
        private String number;
        private String zipCode;
        private String city;
        private String country;

        public String getStreet() {
            return this.street;
        }

        public Address setStreet(String street) {
            this.street = street;
            return this;
        }

        public String getNumber() {
            return this.number;
        }

        public Address setNumber(String number) {
            this.number = number;
            return this;
        }

        public String getZipCode() {
            return this.zipCode;
        }

        public Address setZipCode(String zipCode) {
            this.zipCode = zipCode;
            return this;
        }

        public String getCity() {
            return this.city;
        }

        public Address setCity(String city) {
            this.city = city;
            return this;
        }

        public String getCountry() {
            return this.country;
        }

        public Address setCountry(String country) {
            this.country = country;
            return this;
        }

        public String toString() {
            return "Street: " + this.street + "\n" + "Number: " + this.number + "\n" + "Zip: " + this.zipCode + "\n" + "City: " + this.city + "\n" + "Country: " + this.country + "\n";
        }
    }
}

