/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.impl;

import de.skuzzle.test.snapshots.EnableSnapshotTests;
import de.skuzzle.test.snapshots.ForceUpdateSnapshots;
import de.skuzzle.test.snapshots.SnapshotDsl;
import de.skuzzle.test.snapshots.SnapshotTestResult;
import de.skuzzle.test.snapshots.StructuredDataProvider;
import de.skuzzle.test.snapshots.data.text.TextSnapshot;
import de.skuzzle.test.snapshots.impl.MetaTest;
import java.nio.file.Path;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.opentest4j.AssertionFailedError;

public class FailingSnapshotTests {
    private final MetaTest frameworkTest = new MetaTest();

    @Test
    void testFailBecauseForceUpdateFromAnnotationDeprecated() throws Throwable {
        ((AbstractThrowableAssert)this.frameworkTest.expectTestcase(FailBecauseForceUpdateFromAnnotationDeprecated.class).toFailWithExceptionWhich().isInstanceOf(AssertionError.class)).hasMessage(String.format("Snapshots have been updated forcefully.%nRemove 'updateSnapshots = true' attribute from your test class and calls to 'justUpdateSnapshot()' and run the tests again.", new Object[0]));
    }

    @Test
    void testFailBecauseForceUpdateFromAnnotationOnTestClass() throws Throwable {
        ((AbstractThrowableAssert)this.frameworkTest.expectTestcase(FailBecauseForceUpdateFromAnnotationOnTestClass.class).toFailWithExceptionWhich().isInstanceOf(AssertionError.class)).hasMessage(String.format("Snapshots have been updated forcefully.%nRemove 'updateSnapshots = true' attribute from your test class and calls to 'justUpdateSnapshot()' and run the tests again.", new Object[0]));
    }

    @Test
    void testFailBecauseJustUpdate() throws Exception {
        ((AbstractThrowableAssert)this.frameworkTest.expectTestcase(FailBecauseJustUpdate.class).toFailWithExceptionWhich().isInstanceOf(AssertionError.class)).hasMessage(String.format("Snapshots have been updated forcefully.%nRemove 'updateSnapshots = true' attribute from your test class and calls to 'justUpdateSnapshot()' and run the tests again.", new Object[0]));
    }

    @Test
    void testFailBecauseForceUpdateAnnotationOnTestMethod() throws Exception {
        ((AbstractThrowableAssert)this.frameworkTest.expectTestcase(FailBecauseForceUpdateAnnotationOnTestMethod.class).toFailWithExceptionWhich().isInstanceOf(AssertionError.class)).hasMessage(String.format("Snapshots have been updated forcefully.%nRemove 'updateSnapshots = true' attribute from your test class and calls to 'justUpdateSnapshot()' and run the tests again.", new Object[0]));
    }

    @Test
    void testFailBecauseSnapshotMismatch() throws Throwable {
        ((AbstractThrowableAssert)this.frameworkTest.expectTestcase(FailBecauseSnapshotMismatch.class).toFailWithExceptionWhich().isInstanceOf(AssertionError.class)).hasMessage(String.format("Stored snapshot doesn't match actual result.%n%nSnapshot location:%n\t%s%n%nFull unified diff of actual result and stored snapshot:%n+[NOT ]test", Path.of("src/test/resources/de/skuzzle/test/snapshots/impl/FailingSnapshotTests$FailBecauseSnapshotMismatch_snapshots/testWithSnapshot_0.snapshot", new String[0])));
    }

    @Test
    void testFailBecauseInitial() throws Throwable {
        ((AbstractThrowableAssert)this.frameworkTest.expectTestcase(FailBecauseInitial.class).toFailWithExceptionWhich().isInstanceOf(AssertionError.class)).hasMessage(String.format("Snapshots have been created the first time.%nRun the test again and you should see it succeed.", new Object[0]));
    }

    @Test
    void testMultipleAssertions() throws Exception {
        this.frameworkTest.expectTestcase(MultipleAssertions.class).toFailWithExceptionWhich().isInstanceOf(AssertionError.class);
    }

    @Test
    void testSoftAssertions() throws Exception {
        ((AbstractThrowableAssert)new MetaTest().expectTestcase(SoftAssertions.class).toFailWithExceptionWhich().isInstanceOf(AssertionError.class)).hasMessage(String.format("Stored snapshot doesn't match actual result.%n%nSnapshot location:%n\t%s%n%nFull unified diff of actual result and stored snapshot:%ntest+[2]", Path.of("src/test/resources/de/skuzzle/test/snapshots/impl/FailingSnapshotTests$SoftAssertions_snapshots/testWithSnapshot_0.snapshot", new String[0]))).hasSuppressedException((Throwable)new AssertionFailedError(String.format("Stored snapshot doesn't match actual result.%n%nSnapshot location:%n\t%s%n%nFull unified diff of actual result and stored snapshot:%ntest+[3]", Path.of("src/test/resources/de/skuzzle/test/snapshots/impl/FailingSnapshotTests$SoftAssertions_snapshots/testWithSnapshot_1.snapshot", new String[0]))));
    }

    @Test
    void testWhitespacesDuringTextCompare() throws Exception {
        this.frameworkTest.expectTestcase(WhitespacesDuringTextCompare.class).toFailWithExceptionWhich().isInstanceOf(AssertionError.class);
    }

    @Test
    void testWhitespacesDuringStructureTextCompare() throws Exception {
        this.frameworkTest.expectTestcase(WhitespacesDuringStructureTextCompare.class).toFailWithExceptionWhich().isInstanceOf(AssertionError.class);
    }

    @EnableSnapshotTests
    static class WhitespacesDuringStructureTextCompare {
        WhitespacesDuringStructureTextCompare() {
        }

        @Test
        void testWithSnapshot(SnapshotDsl.Snapshot snapshot) throws Throwable {
            MetaTest.assumeMetaTest();
            snapshot.assertThat((Object)"   test   ").as((StructuredDataProvider)TextSnapshot.text().withIgnoreWhitespaces(false)).matchesSnapshotStructure();
        }
    }

    @EnableSnapshotTests
    static class WhitespacesDuringTextCompare {
        WhitespacesDuringTextCompare() {
        }

        @Test
        void testWithSnapshot(SnapshotDsl.Snapshot snapshot) throws Throwable {
            MetaTest.assumeMetaTest();
            snapshot.assertThat((Object)"   test   ").as((StructuredDataProvider)TextSnapshot.text().withIgnoreWhitespaces(false)).matchesSnapshotText();
        }
    }

    @EnableSnapshotTests(softAssertions=true)
    static class SoftAssertions {
        SoftAssertions() {
        }

        @Test
        void testWithSnapshot(SnapshotDsl.Snapshot snapshot) throws Throwable {
            MetaTest.assumeMetaTest();
            snapshot.assertThat((Object)"test2").asText().matchesSnapshotText();
            snapshot.assertThat((Object)"test3").asText().matchesSnapshotText();
        }
    }

    @EnableSnapshotTests
    static class MultipleAssertions {
        MultipleAssertions() {
        }

        @Test
        void testWithSnapshot(SnapshotDsl.Snapshot snapshot) throws Throwable {
            MetaTest.assumeMetaTest();
            snapshot.assertThat((Object)"test").asText().matchesSnapshotText();
            snapshot.assertThat((Object)"test2").asText().matchesSnapshotText();
        }
    }

    @EnableSnapshotTests
    static class FailBecauseInitial {
        FailBecauseInitial() {
        }

        @Test
        void testWithSnapshot(SnapshotDsl.Snapshot snapshot) throws Throwable {
            MetaTest.assumeMetaTest();
            SnapshotTestResult snapshotResult = snapshot.assertThat((Object)"test").asText().matchesSnapshotText();
            snapshotResult.deleteSnapshot();
            Assertions.assertThat((Comparable)snapshotResult.status()).isEqualTo((Object)SnapshotTestResult.SnapshotStatus.CREATED_INITIALLY);
        }
    }

    @EnableSnapshotTests
    static class FailBecauseSnapshotMismatch {
        FailBecauseSnapshotMismatch() {
        }

        @Test
        void testWithSnapshot(SnapshotDsl.Snapshot snapshot) throws Throwable {
            MetaTest.assumeMetaTest();
            SnapshotTestResult snapshotResult = snapshot.assertThat((Object)"NOT test").asText().matchesSnapshotText();
            Assertions.assertThat((Comparable)snapshotResult.status()).isEqualTo((Object)SnapshotTestResult.SnapshotStatus.ASSERTED);
        }
    }

    @EnableSnapshotTests
    static class FailBecauseForceUpdateAnnotationOnTestMethod {
        FailBecauseForceUpdateAnnotationOnTestMethod() {
        }

        @Test
        @ForceUpdateSnapshots
        void testWithSnapshot(SnapshotDsl.Snapshot snapshot) throws Throwable {
            MetaTest.assumeMetaTest();
            SnapshotTestResult snapshotResult = snapshot.assertThat((Object)"test").asText().matchesSnapshotText();
            Assertions.assertThat((Comparable)snapshotResult.status()).isEqualTo((Object)SnapshotTestResult.SnapshotStatus.UPDATED_FORCEFULLY);
        }
    }

    @EnableSnapshotTests
    static class FailBecauseJustUpdate {
        FailBecauseJustUpdate() {
        }

        @Test
        void testWithSnapshot(SnapshotDsl.Snapshot snapshot) throws Throwable {
            MetaTest.assumeMetaTest();
            SnapshotTestResult snapshotResult = snapshot.assertThat((Object)"test").asText().justUpdateSnapshot();
            Assertions.assertThat((Comparable)snapshotResult.status()).isEqualTo((Object)SnapshotTestResult.SnapshotStatus.UPDATED_FORCEFULLY);
        }
    }

    @EnableSnapshotTests
    @ForceUpdateSnapshots
    static class FailBecauseForceUpdateFromAnnotationOnTestClass {
        FailBecauseForceUpdateFromAnnotationOnTestClass() {
        }

        @Test
        void testWithSnapshot(SnapshotDsl.Snapshot snapshot) throws Throwable {
            MetaTest.assumeMetaTest();
            SnapshotTestResult snapshotResult = snapshot.assertThat((Object)"test").asText().matchesSnapshotText();
            Assertions.assertThat((Comparable)snapshotResult.status()).isEqualTo((Object)SnapshotTestResult.SnapshotStatus.UPDATED_FORCEFULLY);
        }
    }

    @EnableSnapshotTests(forceUpdateSnapshots=true)
    static class FailBecauseForceUpdateFromAnnotationDeprecated {
        FailBecauseForceUpdateFromAnnotationDeprecated() {
        }

        @Test
        void testWithSnapshot(SnapshotDsl.Snapshot snapshot) throws Throwable {
            MetaTest.assumeMetaTest();
            SnapshotTestResult snapshotResult = snapshot.assertThat((Object)"test").asText().matchesSnapshotText();
            Assertions.assertThat((Comparable)snapshotResult.status()).isEqualTo((Object)SnapshotTestResult.SnapshotStatus.UPDATED_FORCEFULLY);
        }
    }
}

