/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots;

import de.skuzzle.test.snapshots.SnapshotFile;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class SnapshotFileTest {
    private BufferedReader string(String s) {
        return new BufferedReader(new StringReader(s));
    }

    @Test
    void testWriteRead() throws Exception {
        SnapshotFile snapshotFile = SnapshotFile.of((SnapshotFile.SnapshotHeader)SnapshotFile.SnapshotHeader.fromMap(Map.of("key", "value")), (String)"actualSnapshot");
        this.assertSameAfterWriteRead(snapshotFile);
    }

    @Test
    void testWriteReadEmptyHeader() throws Exception {
        SnapshotFile snapshotFile = SnapshotFile.of((SnapshotFile.SnapshotHeader)SnapshotFile.SnapshotHeader.fromMap(Map.of()), (String)"actualSnapshot");
        this.assertSameAfterWriteRead(snapshotFile);
    }

    @Test
    void testSnapshotStartsWithNewLines() throws Exception {
        SnapshotFile snapshotFile = SnapshotFile.of((SnapshotFile.SnapshotHeader)SnapshotFile.SnapshotHeader.fromMap(Map.of("key", "value")), (String)"\nactualSnapshot");
        this.assertSameAfterWriteRead(snapshotFile);
    }

    private void assertSameAfterWriteRead(SnapshotFile snapshotFile) throws IOException {
        StringWriter writer = new StringWriter();
        snapshotFile.writeTo((Writer)writer);
        SnapshotFile snapshotFile2 = SnapshotFile.readFrom((BufferedReader)this.string(writer.toString()));
        Assertions.assertThat((Object)snapshotFile).isEqualTo((Object)snapshotFile2);
    }

    @Test
    void testSnapshotFileEquals() throws Exception {
        EqualsVerifier.forClass(SnapshotFile.class).verify();
    }

    @Test
    void testHeaderEquals() throws Exception {
        EqualsVerifier.forClass(SnapshotFile.SnapshotHeader.class).verify();
    }

    @Test
    void testReadSnapshotFile() throws Exception {
        SnapshotFile snapshotFile = SnapshotFile.readFrom((BufferedReader)this.string("key1:value1\n\nactualSnapshot"));
        Assertions.assertThat((Object)snapshotFile.header()).isEqualTo((Object)SnapshotFile.SnapshotHeader.fromMap(Map.of("key1", "value1")));
        Assertions.assertThat((String)snapshotFile.snapshot()).isEqualTo("actualSnapshot");
    }

    @Test
    void testReadHeaderNoNewLineAtTheEnd() throws Exception {
        SnapshotFile.SnapshotHeader fromReader = SnapshotFile.SnapshotHeader.readFrom((BufferedReader)this.string("key1: value1\nkey2:value2:with:colons"));
        Assertions.assertThat((Object)fromReader).isEqualTo((Object)SnapshotFile.SnapshotHeader.fromMap(Map.of("key1", "value1", "key2", "value2:with:colons")));
    }

    @Test
    void testReadHeaderUntilBlankLine() throws Exception {
        SnapshotFile.SnapshotHeader fromReader = SnapshotFile.SnapshotHeader.readFrom((BufferedReader)this.string("key1: value1\nkey2:value2:with:colons\n\nkey3:should be ignored"));
        Assertions.assertThat((Object)fromReader).isEqualTo((Object)SnapshotFile.SnapshotHeader.fromMap(Map.of("key1", "value1", "key2", "value2:with:colons")));
    }
}

