/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.junit5;

import de.skuzzle.test.snapshots.impl.SnapshotTestContext;
import de.skuzzle.test.snapshots.junit5.JUnit5SnapshotExtension;
import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.ExtensionContext;

@API(status=API.Status.INTERNAL, since="1.1.0")
final class Junit5SnapshotTestContextProvider {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{JUnit5SnapshotExtension.class});
    private static final String KEY_SELF = "SNAPSHOT_CONTEXT";

    Junit5SnapshotTestContextProvider() {
    }

    public static SnapshotTestContext fromExtensionContext(ExtensionContext extensionContext) {
        return Junit5SnapshotTestContextProvider.searchParents(extensionContext).orElseThrow(() -> new IllegalStateException("SnapshotTestContext not found on given ExtensionContext or any of its parents"));
    }

    public static SnapshotTestContext create(ExtensionContext extensionContext) {
        Junit5SnapshotTestContextProvider.searchParents(extensionContext).ifPresent(existingContext -> {
            throw new IllegalStateException("There is already a SnapshotTestContext attached to the given ExtensionContext or any of its parents");
        });
        Class testClass = extensionContext.getRequiredTestClass();
        SnapshotTestContext snapshotTestContext = SnapshotTestContext.forTestClass(testClass);
        extensionContext.getStore(NAMESPACE).put((Object)KEY_SELF, (Object)snapshotTestContext);
        return snapshotTestContext;
    }

    private static Optional<SnapshotTestContext> searchParents(ExtensionContext extensionContext) {
        ExtensionContext current = extensionContext;
        while (current != null) {
            SnapshotTestContext snapshotTestContext = (SnapshotTestContext)current.getStore(NAMESPACE).get((Object)KEY_SELF, SnapshotTestContext.class);
            if (snapshotTestContext != null) {
                return Optional.of(snapshotTestContext);
            }
            current = current.getParent().orElse(null);
        }
        return Optional.empty();
    }
}

