/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.junit5;

import de.skuzzle.test.snapshots.impl.SnapshotTestContext;
import de.skuzzle.test.snapshots.junit5.Junit5SnapshotTestContextProvider;
import java.lang.reflect.Method;
import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestWatcher;

@API(status=API.Status.INTERNAL)
public final class JUnit5SnapshotExtension
implements ParameterResolver,
BeforeAllCallback,
AfterEachCallback,
AfterAllCallback,
TestWatcher {
    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        Junit5SnapshotTestContextProvider.create(extensionContext);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        SnapshotTestContext snapshotTestContext = Junit5SnapshotTestContextProvider.fromExtensionContext(extensionContext);
        Class<?> parameterType = parameterContext.getParameter().getType();
        return snapshotTestContext.isSnapshotParameter(parameterType);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        SnapshotTestContext snapshotTestContext = Junit5SnapshotTestContextProvider.fromExtensionContext(extensionContext);
        Method testMethod = extensionContext.getRequiredTestMethod();
        return snapshotTestContext.createSnapshotTestFor(testMethod);
    }

    public void afterEach(ExtensionContext extensionContext) throws Exception {
        Junit5SnapshotTestContextProvider.fromExtensionContext(extensionContext).finalizeSnapshotTest();
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        Junit5SnapshotTestContextProvider.fromExtensionContext(extensionContext).detectOrCleanupOrphanedSnapshots();
    }

    public void testFailed(ExtensionContext extensionContext, Throwable cause) {
        Junit5SnapshotTestContextProvider.fromExtensionContext(extensionContext).recordFailedOrSkippedTest(extensionContext.getRequiredTestMethod());
    }

    public void testAborted(ExtensionContext extensionContext, Throwable cause) {
        Junit5SnapshotTestContextProvider.fromExtensionContext(extensionContext).recordFailedOrSkippedTest(extensionContext.getRequiredTestMethod());
    }

    public void testDisabled(ExtensionContext extensionContext, Optional<String> reason) {
        Junit5SnapshotTestContextProvider.fromExtensionContext(extensionContext).recordFailedOrSkippedTest(extensionContext.getRequiredTestMethod());
    }
}

