/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.impl;

import de.skuzzle.test.snapshots.SnapshotDsl;
import de.skuzzle.test.snapshots.SnapshotException;
import de.skuzzle.test.snapshots.SnapshotFile;
import de.skuzzle.test.snapshots.SnapshotNaming;
import de.skuzzle.test.snapshots.SnapshotSerializer;
import de.skuzzle.test.snapshots.SnapshotTestResult;
import de.skuzzle.test.snapshots.StructuralAssertions;
import de.skuzzle.test.snapshots.impl.InternalSnapshotNaming;
import de.skuzzle.test.snapshots.impl.LocalResultCollector;
import de.skuzzle.test.snapshots.impl.SnapshotConfiguration;
import de.skuzzle.test.snapshots.impl.SnapshotDslImpl;
import de.skuzzle.test.snapshots.impl.SnapshotTestContext;
import de.skuzzle.test.snapshots.validation.Arguments;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import org.opentest4j.AssertionFailedError;

final class SnapshotTestImpl
implements SnapshotDsl.Snapshot {
    private final Method testMethod;
    private final SnapshotTestContext context;
    private final SnapshotConfiguration configuration;
    private final LocalResultCollector localResultCollector = new LocalResultCollector();
    private SnapshotNaming namingStrategy = SnapshotNaming.defaultNaming();
    private Path directoryOverride;

    SnapshotTestImpl(SnapshotTestContext context, SnapshotConfiguration configuration, Method testMethod) {
        this.configuration = (SnapshotConfiguration)Arguments.requireNonNull((Object)configuration, (String)"configuration must not be null");
        this.testMethod = (Method)Arguments.requireNonNull((Object)testMethod, (String)"testMethod must not be null");
        this.context = context;
    }

    @Override
    public SnapshotDsl.ChooseActual namedAccordingTo(SnapshotNaming namingStrategy) {
        this.namingStrategy = (SnapshotNaming)Arguments.requireNonNull((Object)namingStrategy, (String)"namingStrategy must not be null");
        return this;
    }

    @Override
    public SnapshotDsl.ChooseName in(Path directory) {
        this.directoryOverride = (Path)Arguments.requireNonNull((Object)directory, (String)"snapshot directory must not be null");
        return this;
    }

    @Override
    public SnapshotDsl.ChooseDataFormat assertThat(Object actual) {
        return new SnapshotDslImpl(this, actual);
    }

    private SnapshotFile.SnapshotHeader determineNextSnapshotHeader(String snapshotName) {
        return SnapshotFile.SnapshotHeader.fromMap(Map.of("snapshot-number", "" + this.localResultCollector.size(), "test-method", this.testMethod.getName(), "test-class", this.configuration.testClass().getName(), "snapshot-name", snapshotName, "dynamic-directory", "" + (this.directoryOverride != null)));
    }

    private Path determineSnapshotFile(String snapshotName) throws IOException {
        String snapshotFileName = InternalSnapshotNaming.getSnapshotFileName(snapshotName);
        return this.determineSnapshotDirectory().resolve(snapshotFileName);
    }

    private Path determineSnapshotDirectory() {
        return this.directoryOverride != null ? this.directoryOverride : this.configuration.determineSnapshotDirectory();
    }

    SnapshotTestResult justUpdateSnapshotWith(SnapshotSerializer snapshotSerializer, Object actual) throws Exception {
        String snapshotName = this.namingStrategy.determineSnapshotName(this.testMethod, this.localResultCollector.size());
        Path snapshotFilePath = this.determineSnapshotFile(snapshotName);
        String serializedActual = snapshotSerializer.serialize(actual);
        SnapshotFile.SnapshotHeader snapshotHeader = this.determineNextSnapshotHeader(snapshotName);
        SnapshotFile snapshotFile = SnapshotFile.of(snapshotHeader, serializedActual).writeTo(snapshotFilePath);
        SnapshotTestResult result = SnapshotTestResult.of(snapshotFilePath, SnapshotTestResult.SnapshotStatus.UPDATED_FORCEFULLY, snapshotFile);
        this.recordSnapshotTestResult(result);
        return result;
    }

    private void recordSnapshotTestResult(SnapshotTestResult result) {
        this.localResultCollector.recordSnapshotTestResult(result);
        this.context.recordSnapshotTestResult(result);
    }

    SnapshotTestResult executeAssertionWith(SnapshotSerializer snapshotSerializer, StructuralAssertions structuralAssertions, Object actual) throws Exception {
        SnapshotTestResult result;
        String snapshotName = this.namingStrategy.determineSnapshotName(this.testMethod, this.localResultCollector.size());
        Path snapshotFilePath = this.determineSnapshotFile(snapshotName);
        String serializedActual = snapshotSerializer.serialize(actual);
        boolean forceUpdateSnapshots = this.configuration.isForceUpdateSnapshotsLocal(this.testMethod);
        boolean snapshotFileAlreadyExists = Files.exists(snapshotFilePath, new LinkOption[0]);
        SnapshotFile.SnapshotHeader snapshotHeader = this.determineNextSnapshotHeader(snapshotName);
        if (forceUpdateSnapshots || !snapshotFileAlreadyExists) {
            SnapshotFile snapshotFile = SnapshotFile.of(snapshotHeader, serializedActual).writeTo(snapshotFilePath);
            SnapshotTestResult.SnapshotStatus status = snapshotFileAlreadyExists ? SnapshotTestResult.SnapshotStatus.UPDATED_FORCEFULLY : SnapshotTestResult.SnapshotStatus.CREATED_INITIALLY;
            result = SnapshotTestResult.of(snapshotFilePath, status, snapshotFile);
        } else {
            SnapshotFile snapshotFile = this.readSnapshotFileAndUpdateHeader(snapshotFilePath, snapshotHeader);
            String storedSnapshot = snapshotFile.snapshot();
            result = this.compareTestResults(structuralAssertions, storedSnapshot, serializedActual).map(assertionError -> SnapshotTestResult.forFailedTest(snapshotFilePath, snapshotFile, assertionError)).orElseGet(() -> SnapshotTestResult.of(snapshotFilePath, SnapshotTestResult.SnapshotStatus.ASSERTED, snapshotFile));
        }
        this.recordSnapshotTestResult(result);
        if (!this.configuration.isSoftAssertions()) {
            this.localResultCollector.assertSuccessEagerly();
        }
        return result;
    }

    private SnapshotFile readSnapshotFileAndUpdateHeader(Path snapshotFilePath, SnapshotFile.SnapshotHeader newHeader) throws IOException {
        SnapshotFile snapshotFile = SnapshotFile.fromSnapshotFile(snapshotFilePath);
        if (!newHeader.equals(snapshotFile.header())) {
            snapshotFile = snapshotFile.changeHeader(newHeader).writeTo(snapshotFilePath);
        }
        return snapshotFile;
    }

    public void executeFinalAssertions() throws Exception {
        this.localResultCollector.assertSuccess();
    }

    private Optional<Throwable> compareTestResults(StructuralAssertions structuralAssertions, String storedSnapshot, String serializedActual) {
        try {
            structuralAssertions.assertEquals(storedSnapshot, serializedActual);
            return Optional.empty();
        }
        catch (AssertionError e) {
            AssertionError diffableAssertionError = this.toDiffableAssertionError(e, serializedActual, storedSnapshot);
            return Optional.of(diffableAssertionError);
        }
        catch (SnapshotException e) {
            return Optional.of(e);
        }
    }

    private AssertionError toDiffableAssertionError(AssertionError original, String serializedActual, String storedSnapshot) {
        if (original instanceof AssertionFailedError) {
            return original;
        }
        return new AssertionFailedError(((Throwable)((Object)original)).getMessage(), (Object)storedSnapshot, (Object)serializedActual, (Throwable)((Object)original));
    }
}

