/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.impl;

import de.skuzzle.test.snapshots.SnapshotDsl;
import de.skuzzle.test.snapshots.SnapshotTestResult;
import de.skuzzle.test.snapshots.impl.DefaultSnapshotConfiguration;
import de.skuzzle.test.snapshots.impl.DynamicOrphanedSnapshotsDetector;
import de.skuzzle.test.snapshots.impl.OrphanCollectorHolder;
import de.skuzzle.test.snapshots.impl.OrphanDetectionResult;
import de.skuzzle.test.snapshots.impl.OrphanPostProcessor;
import de.skuzzle.test.snapshots.impl.SnapshotConfiguration;
import de.skuzzle.test.snapshots.impl.SnapshotTestImpl;
import de.skuzzle.test.snapshots.impl.StaticOrphanedSnapshotDetector;
import de.skuzzle.test.snapshots.io.DirectoryResolver;
import de.skuzzle.test.snapshots.io.UncheckedIO;
import de.skuzzle.test.snapshots.validation.Arguments;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL, since="1.1.0")
public final class SnapshotTestContext {
    private static final System.Logger log = System.getLogger(SnapshotTestContext.class.getName());
    private final DynamicOrphanedSnapshotsDetector dynamicOrphanedSnapshotsDetector = new DynamicOrphanedSnapshotsDetector();
    private final SnapshotConfiguration snapshotConfiguration;
    private SnapshotTestImpl currentSnapshotTest;

    private SnapshotTestContext(SnapshotConfiguration snapshotConfiguration) {
        this.snapshotConfiguration = (SnapshotConfiguration)Arguments.requireNonNull((Object)snapshotConfiguration, (String)"snapshotConfiguration must not be null");
    }

    public static SnapshotTestContext forTestClass(Class<?> testClass) {
        SnapshotConfiguration configuration = DefaultSnapshotConfiguration.forTestClass(testClass);
        return new SnapshotTestContext(configuration);
    }

    static SnapshotTestContext forConfiguration(SnapshotConfiguration snapshotConfiguration) {
        return new SnapshotTestContext(snapshotConfiguration);
    }

    public boolean isSnapshotParameter(Class<?> type) {
        return type == SnapshotDsl.Snapshot.class;
    }

    public SnapshotDsl.Snapshot createSnapshotTestFor(Method testMethod) {
        if (this.currentSnapshotTest != null) {
            throw new IllegalStateException("There is already a current snapshot test");
        }
        this.currentSnapshotTest = new SnapshotTestImpl(this, this.snapshotConfiguration, testMethod);
        return this.currentSnapshotTest;
    }

    public void finalizeSnapshotTest() throws Exception {
        SnapshotTestImpl current = this.currentSnapshotTest;
        this.currentSnapshotTest = null;
        if (current != null) {
            current.executeFinalAssertions();
        }
    }

    public void recordFailedOrSkippedTest(Method testMethod) {
        this.dynamicOrphanedSnapshotsDetector.addFailedOrSkippedTestMethod(testMethod);
    }

    public void recordSnapshotTestResult(SnapshotTestResult result) {
        this.dynamicOrphanedSnapshotsDetector.addResult(result);
    }

    public Collection<Path> detectOrCleanupOrphanedSnapshots() {
        boolean deleteOrphaned = this.snapshotConfiguration.isDeleteOrphanedSnapshots();
        Path globalSnapshotDirectory = this.snapshotConfiguration.determineSnapshotDirectory();
        OrphanCollectorHolder.OrphanCollector collector = OrphanCollectorHolder.getCollector();
        Stream<OrphanDetectionResult> dynamicOrphans = this.dynamicOrphanedSnapshotsDetector.detectOrphans(globalSnapshotDirectory).peek(collector::addRawResult);
        Stream<OrphanDetectionResult> staticOrphans = new StaticOrphanedSnapshotDetector().detectOrphans(DirectoryResolver.BASE).peek(collector::addRawResult);
        return new OrphanPostProcessor().orphanedOnly(Stream.concat(dynamicOrphans, staticOrphans).collect(Collectors.toList())).peek(collector::addPostProcessedResult).map(OrphanDetectionResult::snapshotFile).distinct().peek(orphaned -> {
            if (deleteOrphaned) {
                UncheckedIO.delete((Path)orphaned);
                log.log(System.Logger.Level.INFO, "Deleted orphaned snapshot file {0} in {1}", orphaned.getFileName(), orphaned.getParent());
            } else {
                log.log(System.Logger.Level.WARNING, "Found orphaned snapshot file. Run with '@DeleteOrphanedSnapshots' annotation to remove: {0} in {1}", orphaned.getFileName(), orphaned.getParent());
            }
        }).collect(Collectors.toList());
    }
}

