/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.impl;

import de.skuzzle.test.snapshots.SnapshotDsl;
import de.skuzzle.test.snapshots.SnapshotSerializer;
import de.skuzzle.test.snapshots.SnapshotTestResult;
import de.skuzzle.test.snapshots.StructuralAssertions;
import de.skuzzle.test.snapshots.StructuredData;
import de.skuzzle.test.snapshots.StructuredDataProvider;
import de.skuzzle.test.snapshots.data.text.TextSnapshot;
import de.skuzzle.test.snapshots.impl.SnapshotTestImpl;
import de.skuzzle.test.snapshots.validation.Arguments;

final class SnapshotDslImpl
implements SnapshotDsl.ChooseActual,
SnapshotDsl.ChooseDataFormat,
SnapshotDsl.ChooseStructure,
SnapshotDsl.ChooseAssertions {
    private final SnapshotTestImpl snapshot;
    private Object actual;
    private SnapshotSerializer snapshotSerializer = TextSnapshot.text.snapshotSerializer();
    private StructuralAssertions structuralAssertions = TextSnapshot.text.structuralAssertions();

    SnapshotDslImpl(SnapshotTestImpl snapshot, Object actual) {
        this.snapshot = (SnapshotTestImpl)Arguments.requireNonNull((Object)snapshot);
        this.actual = actual;
    }

    @Override
    public SnapshotDsl.ChooseDataFormat assertThat(Object actual) {
        this.actual = actual;
        return this;
    }

    @Override
    public SnapshotDsl.ChooseAssertions asText() {
        return this.as(TextSnapshot.text);
    }

    @Override
    public SnapshotDsl.ChooseAssertions as(SnapshotSerializer serializer) {
        this.snapshotSerializer = (SnapshotSerializer)Arguments.requireNonNull((Object)serializer, (String)"serializer must not be null");
        return this;
    }

    @Override
    public SnapshotDsl.ChooseStructure as(StructuredDataProvider structuredDataBuilder) {
        StructuredData structure = ((StructuredDataProvider)Arguments.requireNonNull((Object)structuredDataBuilder, (String)"structuredDataBuilder must not be null")).build();
        this.snapshotSerializer = structure.snapshotSerializer();
        this.structuralAssertions = structure.structuralAssertions();
        return this;
    }

    @Override
    public SnapshotTestResult matchesSnapshotText() {
        return this.matchesAccordingTo(TextSnapshot.text.structuralAssertions());
    }

    @Override
    public SnapshotTestResult matchesSnapshotStructure() throws Exception {
        return this.matchesAccordingTo(this.structuralAssertions);
    }

    @Override
    public SnapshotTestResult matchesAccordingTo(StructuralAssertions structuralAssertions) {
        Arguments.requireNonNull((Object)structuralAssertions, (String)"structuralAssertions must not be null");
        try {
            return this.snapshot.executeAssertionWith(this.snapshotSerializer, structuralAssertions, this.actual);
        }
        catch (Exception e) {
            throw new IllegalStateException("Technical problem while performing the snapshot assertion", e);
        }
    }

    @Override
    public SnapshotTestResult justUpdateSnapshot() {
        try {
            return this.snapshot.justUpdateSnapshotWith(this.snapshotSerializer, this.actual);
        }
        catch (Exception e) {
            throw new IllegalStateException("Technical problem while updating the snapshot", e);
        }
    }
}

