/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.impl;

import de.skuzzle.test.snapshots.SnapshotTestResult;
import de.skuzzle.test.snapshots.impl.Throwables;
import de.skuzzle.test.snapshots.validation.Arguments;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

final class LocalResultCollector {
    private final List<SnapshotTestResult> results = new ArrayList<SnapshotTestResult>();

    LocalResultCollector() {
    }

    public void recordSnapshotTestResult(SnapshotTestResult result) {
        this.results.add((SnapshotTestResult)Arguments.requireNonNull((Object)result));
    }

    public int size() {
        return this.results.size();
    }

    public void assertSuccess() throws Exception {
        Throwable failures = Throwables.flattenThrowables(this.results.stream().map(SnapshotTestResult::failure).flatMap(Optional::stream));
        failures = Throwables.combine(failures, this.failIfCreatedInitially());
        failures = Throwables.combine(failures, this.failIfUpdatedForcefully());
        Throwables.throwIfNotNull(failures);
    }

    public void assertSuccessEagerly() throws Exception {
        Throwable failures = Throwables.flattenThrowables(this.results.stream().map(SnapshotTestResult::failure).flatMap(Optional::stream));
        Throwables.throwIfNotNull(failures);
    }

    private Throwable failIfCreatedInitially() {
        if (this.wasCreatedInitially()) {
            return new AssertionError((Object)String.format("Snapshots have been created the first time.%nRun the test again and you should see it succeed.", new Object[0]));
        }
        return null;
    }

    private Throwable failIfUpdatedForcefully() {
        if (this.wasUpdatedForcefully()) {
            return new AssertionError((Object)String.format("Snapshots have been updated forcefully.%nRemove 'updateSnapshots = true' attribute from your test class and calls to 'justUpdateSnapshot()' and run the tests again.", new Object[0]));
        }
        return null;
    }

    private boolean wasCreatedInitially() {
        return this.results.stream().map(SnapshotTestResult::status).anyMatch(SnapshotTestResult.SnapshotStatus.CREATED_INITIALLY::equals);
    }

    private boolean wasUpdatedForcefully() {
        return this.results.stream().map(SnapshotTestResult::status).anyMatch(SnapshotTestResult.SnapshotStatus.UPDATED_FORCEFULLY::equals);
    }
}

