/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.data.text;

import de.skuzzle.test.snapshots.data.text.DiffInterpreter;
import de.skuzzle.test.snapshots.data.text.diff_match_patch;
import java.util.LinkedList;

final class TextDiff {
    private final DiffInterpreter diffInterpreter = new DiffInterpreter().withIgnoreWhitespaceChanges(true);
    private final LinkedList<diff_match_patch.Diff> diffs;

    private TextDiff(LinkedList<diff_match_patch.Diff> diffs) {
        this.diffs = diffs;
    }

    public static TextDiff diffOf(String expected, String actual) {
        diff_match_patch diff_match_patch2 = new diff_match_patch();
        LinkedList<diff_match_patch.Diff> diffs = diff_match_patch2.diff_main(expected, actual);
        diff_match_patch2.diff_cleanupEfficiency(diffs);
        return new TextDiff(diffs);
    }

    public boolean hasDifference() {
        return this.diffInterpreter.hasFailures(this.diffs);
    }

    public String toString() {
        StringBuilder message = new StringBuilder();
        for (diff_match_patch.Diff diff : this.diffs) {
            message.append(this.diffInterpreter.getDisplayDiff(diff));
        }
        return message.toString();
    }
}

