/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.data.text;

import de.skuzzle.test.snapshots.data.text.diff_match_patch;
import java.util.Collection;
import java.util.regex.Pattern;

final class DiffInterpreter {
    private static final Pattern WHITESPACE_ONLY = Pattern.compile("\\s+");
    private boolean ignoreWhitespaceChanges = false;

    DiffInterpreter() {
    }

    public DiffInterpreter withIgnoreWhitespaceChanges(boolean ignoreWhitespaceChanges) {
        this.ignoreWhitespaceChanges = ignoreWhitespaceChanges;
        return this;
    }

    private boolean isWhitespace(diff_match_patch.Diff diff) {
        return WHITESPACE_ONLY.matcher(diff.text).matches();
    }

    public boolean hasFailures(Collection<diff_match_patch.Diff> diffs) {
        return diffs.stream().anyMatch(this::isFailureDifference);
    }

    private boolean isFailureDifference(diff_match_patch.Diff diff) {
        return diff.operation != diff_match_patch.Operation.EQUAL && (!this.ignoreWhitespaceChanges || !this.isWhitespace(diff));
    }

    public String getDisplayDiff(diff_match_patch.Diff diff) {
        if (this.isFailureDifference(diff)) {
            switch (diff.operation) {
                case DELETE: {
                    return "-" + this.einklammern(diff.text);
                }
                case INSERT: {
                    return "+" + this.einklammern(diff.text);
                }
            }
            throw new IllegalStateException();
        }
        return diff.text;
    }

    private String einklammern(String text) {
        if (text.endsWith("\r\n")) {
            return "[" + text.substring(0, text.length() - 2) + "]\r\n";
        }
        if (text.endsWith("\r")) {
            return "[" + text.substring(0, text.length() - 1) + "]\r";
        }
        if (text.endsWith("\n")) {
            return "[" + text.substring(0, text.length() - 1) + "]\n";
        }
        return "[" + text + "]";
    }
}

