/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots;

import de.skuzzle.test.snapshots.SnapshotFile;
import de.skuzzle.test.snapshots.validation.Arguments;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL)
public final class SnapshotTestResult {
    private final SnapshotFile snapshot;
    private final Path targetFile;
    private final SnapshotStatus status;
    private final Throwable failure;

    private SnapshotTestResult(Path targetFile, SnapshotStatus status, SnapshotFile snapshot, Throwable failure) {
        this.targetFile = (Path)Arguments.requireNonNull((Object)targetFile);
        this.status = (SnapshotStatus)((Object)Arguments.requireNonNull((Object)((Object)status)));
        this.snapshot = (SnapshotFile)Arguments.requireNonNull((Object)snapshot);
        this.failure = failure;
    }

    public static SnapshotTestResult forFailedTest(Path targetFile, SnapshotFile snapshot, Throwable failure) {
        return new SnapshotTestResult(targetFile, SnapshotStatus.ASSERTED, snapshot, (Throwable)Arguments.requireNonNull((Object)failure));
    }

    public static SnapshotTestResult of(Path targetFile, SnapshotStatus status, SnapshotFile snapshot) {
        return new SnapshotTestResult(targetFile, status, snapshot, null);
    }

    public Path targetFile() {
        return this.targetFile;
    }

    public SnapshotStatus status() {
        return this.status;
    }

    public SnapshotFile serializedSnapshot() {
        return this.snapshot;
    }

    public Optional<Throwable> failure() {
        return Optional.ofNullable(this.failure);
    }

    public void deleteSnapshot() throws IOException {
        Files.delete(this.targetFile);
    }

    public String toString() {
        return "status=" + (Object)((Object)this.status) + ", targetFile=" + this.targetFile;
    }

    public static enum SnapshotStatus {
        CREATED_INITIALLY,
        UPDATED_FORCEFULLY,
        ASSERTED;

    }
}

