/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.junit5;

import de.skuzzle.test.snapshots.Snapshot;
import de.skuzzle.test.snapshots.impl.TestFrameworkSupport;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.opentest4j.TestAbortedException;

final class JUnit5TestFrameworkSupport
implements TestFrameworkSupport {
    static final TestFrameworkSupport INSTANCE = new JUnit5TestFrameworkSupport();

    private JUnit5TestFrameworkSupport() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isSnapshotTest(Class<?> testClass, Method testMethod) {
        if (Modifier.isStatic(testMethod.getModifiers())) return false;
        if (Modifier.isPrivate(testMethod.getModifiers())) return false;
        if (!Arrays.stream(testMethod.getParameterTypes()).anyMatch(Snapshot.class::isAssignableFrom)) return false;
        return true;
    }

    @Override
    public Throwable assumptionFailed(String message) {
        return new TestAbortedException(message);
    }
}

