/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.junit5;

import de.skuzzle.test.snapshots.impl.SnapshotTestContext;
import de.skuzzle.test.snapshots.junit5.DetectJunit5Module;
import de.skuzzle.test.snapshots.junit5.Junit5SnapshotTestContextProvider;
import java.lang.reflect.Method;
import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestWatcher;

@API(status=API.Status.INTERNAL)
class JUnit5SnapshotExtension
implements ParameterResolver,
BeforeAllCallback,
AfterEachCallback,
AfterAllCallback,
TestWatcher {
    static final DetectJunit5Module DETECT_JUNIT5 = new DetectJunit5Module();

    JUnit5SnapshotExtension() {
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        Junit5SnapshotTestContextProvider.create(extensionContext);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> parameterType;
        SnapshotTestContext snapshotTestContext = Junit5SnapshotTestContextProvider.fromExtensionContext(extensionContext);
        return snapshotTestContext.isSnapshotParameter(parameterType = parameterContext.getParameter().getType()) || SnapshotTestContext.class.isAssignableFrom(parameterType);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        SnapshotTestContext snapshotTestContext = Junit5SnapshotTestContextProvider.fromExtensionContext(extensionContext);
        if (parameterContext.getParameter().getType().isAssignableFrom(SnapshotTestContext.class)) {
            return snapshotTestContext;
        }
        Method testMethod = extensionContext.getRequiredTestMethod();
        return snapshotTestContext.createSnapshotTestFor(testMethod);
    }

    public void afterEach(ExtensionContext extensionContext) throws Exception {
        Junit5SnapshotTestContextProvider.fromExtensionContext(extensionContext).finalizeSnapshotTest();
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        Junit5SnapshotTestContextProvider.fromExtensionContext(extensionContext).detectOrCleanupOrphanedSnapshots();
    }

    public void testFailed(ExtensionContext extensionContext, Throwable cause) {
        Junit5SnapshotTestContextProvider.fromExtensionContext(extensionContext).recordFailedOrSkippedTest(extensionContext.getRequiredTestMethod());
    }

    public void testAborted(ExtensionContext extensionContext, Throwable cause) {
        Junit5SnapshotTestContextProvider.fromExtensionContext(extensionContext).recordFailedOrSkippedTest(extensionContext.getRequiredTestMethod());
    }

    public void testDisabled(ExtensionContext extensionContext, Optional<String> reason) {
        Junit5SnapshotTestContextProvider.fromExtensionContext(extensionContext).recordFailedOrSkippedTest(extensionContext.getRequiredTestMethod());
    }
}

