/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.impl;

import de.skuzzle.test.snapshots.validation.Arguments;
import java.lang.annotation.Annotation;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL, since="1.9.0")
final class TestClass {
    private final Class<?> testClass;

    private TestClass(Class<?> testClass) {
        this.testClass = (Class)Arguments.requireNonNull(testClass);
    }

    public static TestClass wrap(Class<?> testClass) {
        return new TestClass(testClass);
    }

    public Class<?> testClass() {
        return this.testClass;
    }

    String getName() {
        return this.testClass.getName();
    }

    <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        for (Class<?> current = this.testClass; current != null; current = current.getEnclosingClass()) {
            T annotation = current.getAnnotation(annotationType);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.getAnnotation(annotationType) != null;
    }
}

