/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.test.snapshots.impl;

import de.skuzzle.test.snapshots.SnapshotFile;
import de.skuzzle.test.snapshots.impl.DefaultSnapshotConfiguration;
import de.skuzzle.test.snapshots.impl.InternalSnapshotNaming;
import de.skuzzle.test.snapshots.impl.OrphanDetectionResult;
import de.skuzzle.test.snapshots.impl.SnapshotConfiguration;
import de.skuzzle.test.snapshots.impl.TestFrameworkSupport;
import de.skuzzle.test.snapshots.io.UncheckedIO;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class StaticOrphanedSnapshotDetector {
    private final TestFrameworkSupport testFrameworkSupport;

    StaticOrphanedSnapshotDetector(TestFrameworkSupport testFrameworkSupport) {
        this.testFrameworkSupport = testFrameworkSupport;
    }

    public Stream<OrphanDetectionResult> detectOrphans(Path root) {
        try (Stream files = UncheckedIO.walk((Path)root);){
            Stream<OrphanDetectionResult> stream = files.filter(InternalSnapshotNaming::isSnapshotFile).map(path -> SnapshotFileAndPath.readFrom(path, this.testFrameworkSupport)).map(SnapshotFileAndPath::toOrphanDetectionResult).collect(Collectors.toList()).stream();
            return stream;
        }
    }

    private static final class SnapshotFileAndPath {
        private final Path path;
        private final SnapshotFile snapshotFile;
        private final TestFrameworkSupport testFrameworkSupport;

        private SnapshotFileAndPath(Path path, SnapshotFile snapshotFile, TestFrameworkSupport testFrameworkSupport) {
            this.path = path;
            this.snapshotFile = snapshotFile;
            this.testFrameworkSupport = testFrameworkSupport;
        }

        static SnapshotFileAndPath readFrom(Path path, TestFrameworkSupport testFrameworkSupport) {
            try {
                SnapshotFile snapshotFile = SnapshotFile.fromSnapshotFile(path);
                return new SnapshotFileAndPath(path, snapshotFile, testFrameworkSupport);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public OrphanDetectionResult toOrphanDetectionResult() {
            return new OrphanDetectionResult(StaticOrphanedSnapshotDetector.class.getSimpleName(), this.path, this.isOrphaned());
        }

        private OrphanDetectionResult.OrphanStatus isOrphaned() {
            Path snapshotFileName;
            Optional<Class<?>> testClass = this.testClass();
            if (testClass.isEmpty()) {
                return OrphanDetectionResult.OrphanStatus.ORPHAN;
            }
            Optional<Method> testMethod = this.testMethodIn(testClass.orElseThrow());
            if (testMethod.isEmpty()) {
                return OrphanDetectionResult.OrphanStatus.ORPHAN;
            }
            if (this.isDynamicDirectory()) {
                return OrphanDetectionResult.OrphanStatus.UNSURE;
            }
            SnapshotConfiguration configuration = DefaultSnapshotConfiguration.forTestClass(testClass.orElseThrow());
            Path snapshotDirectory = configuration.determineSnapshotDirectory();
            boolean fileIsMissing = !Files.exists(snapshotDirectory.resolve(snapshotFileName = this.path.getFileName()), new LinkOption[0]);
            return fileIsMissing ? OrphanDetectionResult.OrphanStatus.ORPHAN : OrphanDetectionResult.OrphanStatus.UNSURE;
        }

        private Optional<Class<?>> testClass() {
            try {
                String className = this.snapshotFile.header().get("test-class");
                Class<?> testClass = Class.forName(className, true, this.getClass().getClassLoader());
                return Optional.of(testClass);
            }
            catch (ClassNotFoundException e) {
                return Optional.empty();
            }
        }

        private Optional<Method> testMethodIn(Class<?> testClass) {
            String methodName = this.snapshotFile.header().get("test-method");
            return Arrays.stream(testClass.getDeclaredMethods()).filter(method -> method.getName().equals(methodName)).filter(method -> this.isSnapshotTest(testClass, (Method)method)).findAny();
        }

        private boolean isDynamicDirectory() {
            return this.snapshotFile.header().getBoolean("dynamic-directory", true);
        }

        private boolean isSnapshotTest(Class<?> testClass, Method method) {
            return this.testFrameworkSupport.isSnapshotTest(testClass, method);
        }
    }
}

